'use strict';

angular.module('zephyrApp')
.controller('BoardController', function ($scope, $modal, Restangular, $state) {
    $scope.commandDirectives = new Array()
    $scope.openCommandModal = function() {
        var modalInstance = $modal.open({
            templateUrl: '/client/app/components/commandModal/commandModal.html',
            controller: 'CommandModalController',
            backdrop: true,
            size: 'lg'
        })
        modalInstance.result.then(function(command) {
            (function addCommandDirective() {
                var obj = {
                    name: command,
                    isCompleted: false
                }
                $scope.commandDirectives.push(obj)
            })()
        })
    }
    $scope.removeCommandDirective= function(index) {
        $scope.commandDirectives.splice(index, 1)
    }
    $scope.save = function() {
        $modal.open({
            templateUrl: '/client/app/components/saveFileModal/saveFileModal.html',
            controller: 'SaveFileModalController',
            backdrop: true,
            scope: $scope
        })
    }
    $scope.$on('updateParams', function(event, index, params) {
        $scope.commandDirectives[index].params = params
        $scope.commandDirectives[index].isCompleted = true
    })

    var note = $state.params.id
    if(note !== 'new') {
        $scope.noteName = note
        var baseNoteInfo = Restangular.all('/api/noteInfo/'+note)
        baseNoteInfo.getList().then(function(commands) {
            $scope.commands = commands 
            commands.forEach(function(params) {
                var obj = {
                    name: params.command,
                    isCompleted: false,
                }
                $scope.commandDirectives.push(obj)
            })
        })
        $scope.$on('requestParams', function(event, i) {
            $scope.$broadcast('sendParams'+i, $scope.commands[i])
        })
    } else {
        $scope.noteName = 'new note' 
    }
});
