'use strict'

angular.module('zephyrApp')
.controller('PreviewModalController', function($scope, $window, $modalInstance, Restangular) {
    var fileName         = $scope.$parent.previewFileName,
        splits           = fileName.split('.'),
        withoutExtension = splits[0],
        extension        = splits[1],
        baseCommandExecution = Restangular.all('/api/commandExecution')

    $scope.fileName     = fileName 

    if(extension === 'gif') {
        var params = {
            command: 'cp workspace/'+$scope.$parent.dirPath+'/'+fileName+' workspace/preview/preview_'+fileName
        }
        baseCommandExecution.post(JSON.stringify(params)).then(function() {
            $scope.previewFileSrc = '/preview/preview_'+fileName
        })
    } else if(extension === 'mrc') {
        var params = {
            command: 'mrc2gif',
            inputDir: $scope.$parent.dirPath+'/',
            outputDir: '/preview/',
            options: [
                {
                    name:"-i",
                    content : [fileName],
                    isFilled: true
                },
                {
                    name: "-o",
                    content: ['preview_'+withoutExtension+'.gif'],
                    isFilled: true
                }
            ]
        }
        baseCommandExecution.post(JSON.stringify(params)).then(function(status) {
            $scope.previewFileSrc = '/preview/preview_'+withoutExtension+'.gif'
            console.log(status)
        })

    } else if(extension === 'tif' || extension === 'tiff') {
        var params = {
            command: 'tiff2mrc',
            inputDir: $scope.$parent.dirPath+'/',
            outputDir: '/preview/',
            options: [
                {
                    name:"-i",
                    content: [fileName],
                    isFilled: true
                },
                {
                    name: "-o",
                    content: ['preview_'+withoutExtension+'.mrc'],
                    isFilled: true
                }
            ]
        }
        var toMrc = baseCommandExecution.post(JSON.stringify(params))
        toMrc.then(function(status) {
            params = {
                command: 'mrc2gif',
                inputDir: '/preview/',
                outputDir: '/preview/',
                options: [
                    {
                        name: "-i",
                        content: ['preview_'+withoutExtension+'.mrc'],
                        isFilled: true
                    },
                    {
                        name: "-o",
                        content: ['preview_'+withoutExtension+'.gif'],
                        isFilled: true
                    }
                ]
            }
            baseCommandExecution.post(JSON.stringify(params)).then(function(status) {
                $scope.previewFileSrc = '/preview/preview_'+withoutExtension+'.gif'
                console.log(status)
            })
        })
    } else {
        var promise = new Promise(function(resolv, reject) {
            resolv()
        })
        promise.
            then(function() {
            $window.alert("Can't open preview image")
        })
        .then(function() {
            $modalInstance.close()
        })
    }
    $scope.close = function() {
        $modalInstance.close()
    }
})
