'use strict'

angular.module('zephyrApp')
.controller('SaveFileModalController', function($scope, $modalInstance, Restangular) {
    var baseNoteSaving = Restangular.all('/api/noteCreation')
    $scope.save = function() {
        var note = {
            name: $scope.noteName
        }
        note.content = new Array()
        angular.forEach($scope.commandDirectives, function(command) {
            if(command.isCompleted) {
                var obj = {
                    command  : command.params.command,
                    inputDir : command.params.inputDir,
                    outputDir: command.params.outputDir,
                    optionDatas  : command.params.options
                }
                note.content.push(obj)
            }
        })
        baseNoteSaving.post(JSON.stringify(note)).then(function(status) {
            console.log(status)
            $modalInstance.close()
        })
    }
    $scope.close = function() {
        $modalInstance.close()
    }
})
