'use strict';

angular.module('zephyrApp')
.controller('MyCommandController', function($scope, $q, $timeout, Restangular, $modal) {
    var baseOptionControlFile = Restangular.all('/api/optionControlFile/'+$scope.command),
        baseCommandExecution  = Restangular.all('/api/commandExecution')

    var getOption = function() {
        $scope.$emit('requestParams', $scope.index)
    }
    baseOptionControlFile.getList().then(function(options) {
        $scope.options = options
        // ***ugly hacks***
        $timeout(getOption, 500)
        // ******
    })

    $scope.$on('sendParams'+$scope.index, function(event,params) {
        // TO DO 
        // +ディレクトリが消去済みのとき
        // +ファイルが消去済みのとき
        $scope.inputDirectory = params.inputDir
        $scope.outputDirectory = params.outputDir
        angular.forEach($scope.options, function(option, i) {
            if(params.optionDatas[i].isFilled) {
                angular.forEach($scope.options[i].arg, function(arg, j) {
                    arg.input = params.optionDatas[i].content[j]
                })
            }
        })
    })

    $scope.executionButton = "Execution"

    $scope.execute = function() {
        $scope.isProcessing = true
        $scope.executionButton = "Now processing..."

        var baseDirInfo = Restangular.all('/api/dirInfo/'+$scope.outputDirectory)
        // ****** //
        var beforeExecutionFiles = baseDirInfo.getList()

        var params = {
            command: $scope.command,
            inputDir: $scope.inputDirectory,
            outputDir: $scope.outputDirectory,
        }
        params.options = new Array()

        // ***ugly hacks***
        angular.forEach($scope.options, function(option) {
            angular.forEach(option.arg, function(arg) {
                if(arg.input) option.isFilled = true
            })
        })
        // *** 

        angular.forEach($scope.options, function(option) {
            var obj = {
                name: option.option,
                isFilled: option.isFilled
            }
            if(option.isFilled) {
                obj.content = new Array()
                angular.forEach(option.arg, function(arg) {
                    obj.content.push(arg.input)
                })
            }
            params.options.push(obj)
        })
        baseCommandExecution.post(JSON.stringify(params)).then(function(status) {
            console.log(status)
            $scope.isProcessing    = false
            $scope.executionButton = "Execution"

            baseDirInfo.getList().then(function(after) {
                beforeExecutionFiles.then(function(before) {
                    var beforeFiles = before.map(function(file) { return file.name })
                    var afterFiles  = after.map(function(file) {return file.name })
                    $scope.previewFiles = _.difference(afterFiles, beforeFiles)
                    .filter(function(file) {
                        var extension = file.split('.').pop()
                        return  (extension === 'mrc' || extension === 'gif' || extension ==='tiff' || extension === 'tif')
                    })
                    $scope.havePreviewFiles = ($scope.previewFiles.length > 0)
                    console.log("havePreviewFiles", $scope.havePreviewFiles)
                })
            })

            // For save notes
            // add options to board's $scope
            $scope.$emit('updateParams', $scope.index, params)
        })
    }
    $scope.removeMyself = function() {
        $scope.$parent.removeCommandDirective($scope.index)
    }
    $scope.$watch('inputDirectory', function() {
        getFilesInfo($scope.inputDirectory)
    })
    function getFilesInfo(name) {
        if(name !== undefined) {
            var baseDirInfo = Restangular.all('/api/dirInfo/'+name)
            baseDirInfo.getList().then(function(files) {
                $scope.files = files.map(function(file) { return file.name })
            })
        }
    }
    $scope.preview = function(name) {
        $scope.dirPath = $scope.outputDirectory
        $scope.previewFileName = name
        var modalInstance = $modal.open({
            templateUrl: '/client/app/components/previewModal/previewModal.html',
            controller: 'PreviewModalController',
            backdrop: false,
            size: 'lg',
            scope: $scope
        })
        modalInstance.result.then(function() {
            var params = {
                command: 'rm workspace/preview/preview*'
            }
            baseCommandExecution.post(JSON.stringify(params))
        })
    }
    var baseDirInfo = Restangular.all('/api/dirInfo/root')
    baseDirInfo.getList().then(function(files) {
        $scope.dirs = files.map(function(file) { return file.name })
    })
})
