var gulp            = require('gulp'),
    exec            = require('child_process').exec,
    uglify          = require('gulp-uglify'),
    inject          = require('gulp-inject'),
    jshint          = require('gulp-jshint'),
    angularFilesort = require('gulp-angular-filesort')
bs                  = require('browser-sync').create(),
    gls             = require('gulp-live-server'),
    concat          = require('gulp-concat'),
    _               = require('lodash'),
    templateCache   = require('gulp-angular-templatecache'),
    tap             = require('gulp-tap'),
    runSequence     = require('run-sequence')

var paths = {
    index      : ['./client/index.html'],
    angular    : ['./client/assets/vendor/angular/*.js'],
    underscore : ['./client/assets/vendor/underscore-min.js'],
    vendor     : ['./client/assets/vendor/*.js', './client/assets/vendor/*.css'],
    app        : ['./client/app/*.js'],
    shared     : ['./client/app/shared/**/*.js'],
    components : ['./client/app/components/**/*.js'],
    templates   : ['./client/app/**/*.html']
};

gulp.task('inject', function() {
    return gulp.src(paths.index)
    .pipe(inject(gulp.src(paths.angular).pipe(angularFilesort()), {name: 'angular'}))
    .pipe(inject(gulp.src(paths.underscore, {read: false}), {name: 'underscore'}))
    .pipe(inject(gulp.src(paths.vendor, {read: false}), {name: 'vendor'}))
    .pipe(inject(gulp.src(paths.app, {read:false}), {name: 'app'}))
    .pipe(inject(gulp.src(paths.shared, {read: false}), {name: 'shared'}))
    .pipe(inject(gulp.src(paths.components, {read:false}), {name: 'components'}))
    .pipe(gulp.dest('./client'));
});

gulp.task('browser-sync', ['serve'], function() {
    bs.init(null, {
        proxy: "http://127.0.0.1:3000",
        browser: "google chrome",
        port: "7000",
        ghostMode: false
    });
});

gulp.task('parse-option', function(cb) {
    return exec('ruby create-json-file.rb', {cwd: './util/'}, function(err) {
        if(err) console.error(err);
        else cb();
    });
});

gulp.task('serve', function(cb) {
    var server = gls.new('./server/app.js');
    server.start();
    cb();
});

gulp.task('watch', function() {
    var pathsArray = new Array();
    Object.keys(paths).forEach(function(key) {
        pathsArray = pathsArray.concat(paths[key]);
    });

    gulp.watch(pathsArray, ['bs-reload']);
});

gulp.task('bs-reload', function() {
    bs.reload();
});

gulp.task('angular-concat', function() {
    return gulp.src(paths.angular)
    .pipe(angularFilesort(), {name: 'angular'}) 
    .pipe(concat('angular.js'))
    .pipe(gulp.dest('./dist/'))
})

gulp.task('js-vendor-concat', function() {
    return gulp.src('./client/assets/vendor/*.js')
    .pipe(concat('vendor.js'))
    .pipe(gulp.dest('./dist/'))
})

gulp.task('underscore', function() {
    return gulp.src(paths.underscore)
    .pipe(concat('underscore.js'))
    .pipe(gulp.dest('./dist/'))
})

gulp.task('js-app', function() {
    return gulp.src(paths.app)
    .pipe(gulp.dest('./dist/'))
})

gulp.task('js-source-concat', function() {
    return gulp.src(_.union(paths.shared, paths.components))
    .pipe(tap(function(file) {
        file.contents = Buffer.concat([
            new Buffer("(function(){\n"),
            file.contents,
            new Buffer("}());")
        ])
    }))
    .pipe(concat('source.js'))
    .pipe(gulp.dest('./dist/'))
})

gulp.task('css-concat', function() {
    return gulp.src(paths.vendor[1])
    .pipe(concat('style.css'))
    .pipe(gulp.dest('./dist/'))
})

gulp.task('cache', function() {
    gulp.src(paths.templates)
    .pipe(templateCache('templates.js', {module: 'zephyrApp', root: '/client/app/'}))
    .pipe(gulp.dest('dist/'))
})

gulp.task('set-production', function() {
    process.env.NODE_ENV = 'production'
})

gulp.task('build', ['angular-concat', 'js-vendor-concat', 'underscore', 'js-app', 'js-source-concat', 'css-concat', 'cache'], function() {
})

gulp.task('default', function(callback) {
    runSequence('inject', 'serve', 'browser-sync', 'watch', callback)
          //['inject', 'browser-sync', 'watch']); 
})
gulp.task('deploy', function(callback) {
    runSequence('build', 'set-production', 'serve', callback)
})
