'use strict';

var express = require('express'),
    router  = express.Router(),
    path    = require('path'),
    fs      = require('fs')

router.get('/:dir', function(req, res) {
    var dir = req.params.dir
    var dirPath
    if(dir === 'root') dirPath = path.normalize(__dirname+'/../../../workspace/')
    else dirPath = path.normalize(__dirname+'/../../../workspace/'+dir)
    var files = fs.readdirSync(dirPath)
    var filesInfo = files.filter(function(file) {
        return file.substring(0,1) !== '.' && file !== 'preview' 
    })
    .map(function(file) {
        var stat = fs.statSync(dirPath+'/'+file)
        stat.name = file
        return stat
    })
    res.send(filesInfo)
})

module.exports = router;
