'use strict';

var express = require('express'),
    router  = express.Router(),
    path    = require('path'),
    fs      = require('fs')

router.get('/:note', function(req, res) {
    var note = req.params.note
    var dirPath
    if(note === 'root') {
        dirPath = path.normalize(__dirname+'/../../../notes/')
        var filesInfo = fs.readdirSync(dirPath).filter(function(file) {
            return file.substring(0,1) !== '.' && file !== 'preview' 
        })
        .map(function(file) {
            var stat = fs.statSync(dirPath+'/'+file)
            stat.name = file
            return stat
        })
        .map(function(stat) {
            stat.name = stat.name.split('.')[0]
            return stat
        })
        res.send(filesInfo)
    } else {
        var noteJSON = require(path.normalize(__dirname+'/../../../notes/'+note+'.json'))
        res.json(noteJSON)
    }
})

module.exports = router;
