'use strict';

var express    = require('express'),
    path       = require('path'),
    config     = require('./config'),
    bodyParser = require('body-parser')

module.exports = function(app) {
    app.set('views', config.root+ '/server/views')
    app.engine('html', require('ejs').renderFile)
    app.set('view engine', 'html')
    app.use('/workspace', express.static('./workspace/'))
    app.use(bodyParser.json())

    if(app.get('env') === 'development') {
        app.use('/client/', express.static('./client/'))
        app.use(express.static(path.join(config.root, 'client')))
    } else if(app.get('env') === 'production') {
        app.use('/dist/', express.static('./dist/'))
        app.use(express.static(path.join(config.root, 'dist')))
    }
};
