'use strict';

var path = require('path');

module.exports = function(app) {
    app.use('/api/optionControlFile', require('./api/optionControlFile'))
    app.use('/api/commandList', require('./api/commandList'))
    app.use('/api/tagList', require('./api/tagList'))
    app.use('/api/optionControlFile', require('./api/optionControlFile'))
    app.use('/api/dirInfo', require('./api/dirInfo'))
    app.use('/api/commandExecution', require('./api/commandExecution'))
    app.use('/api/noteCreation', require('./api/noteCreation'))
    app.use('/api/noteInfo', require('./api/noteInfo'))
    app.route('/*')
    .get(function(req, res) {
        if(app.get('env') === 'development') {
            res.sendFile('index.html', {root: path.normalize(__dirname + '/../client')})
        } else if(app.get('env') === 'production') {
            res.sendFile('index.html', {root: path.normalize(__dirname + '/../dist')})
        }
    })
};
