namespace app.directives {
    export class Command implements ng.IDirective {

        public restrict: string;
        public replace: boolean;
        public templateUrl: string;
        public scope: boolean;
        public controller: string;
        public controllerAs: string;
        public bindToController: Object;

        /** 
         * constructor
         *
         * @param
         */
        constructor() {
            this.restrict = 'E';
            this.replace = true; 
            this.scope = true;
            this.controller = 'commandController';
            this.controllerAs = 'ctrl';
            this.bindToController = {
                index: '=',
                name: '=',
                remove: '&',
                list: '='
            };
            this.templateUrl = 'templates/command.html';
        }

        /**
         * instance生成
         * @returns {function(): HeaderMenu}
         * @constructor
         */
        public static Factory(): ng.IDirectiveFactory {
            var directive = () => {
            return new Command();
            };
            directive.$inject = [];
            return directive;
        }
    }

    export class CommandController {

        public static $inject = ['APIEndPoint', '$scope'];

        // From parent directive.show bindToController property
        private index: string;
        private name: string;
        private remove: Function;
        private list: declares.CommandInfo[];

        // property of ui.bootstrap uib-accordion directive
        private isOpen: boolean;
        private heading: string;

        // property about Option directive
        private files: string[];
        private options: declares.IOption[];

        constructor(private APIEndPoint: services.APIEndPoint, private $scope: ng.IScope) {
            var controller = this;

            // Get OptionControlFile and bind it to $scope.options
            this.APIEndPoint
                .getOptionControlFile()
                .$promise
                .then(function(result) {
                    controller.options = result;
                });

            this.files = ['a.file', 'b.file', 'c.file'];

            this.heading = "[" + this.index + "]: dcdFilePring";
            this.isOpen = true;

            // When call add button at executeController, all accordion close.
            this.$scope.$on('close', () => {
               controller.isOpen = false;
            });
        }

        public submit() {
            var params = {};
            angular.forEach(this.options, (option) => {

                var inputs = [];

                angular.forEach(option.arg, (arg) => {
                    if(arg.input) {
                        inputs.push(arg.input);
                    }
                });

                if(inputs.length > 0) {
                    params[option.option] = inputs;
                }
            });
            console.log(params);
        }

        public removeMySelf(index:number) {
            this.remove()(index,this.list);
        }
    } 
}
