namespace app.controllers {
    export class SelectCommand{ 

        public static $inject = ['$scope', 'APIEndPoint','$uibModalInstance'];
        private tags: string[];
        private commands: string[];
        private searchText: string;
        private currentTag: string;

        constructor($scope: ng.IScope, private APIEndPoint: services.APIEndPoint, private $modalInstance: ng.ui.bootstrap.IModalServiceInstance) {
            var controller = this;
            this.APIEndPoint
                .getTags()
                .$promise.then((result) => {
                   controller.tags = result.info; 
                });

            this.APIEndPoint
                .getCommands()
                .$promise.then((result) => {
                   controller.commands = result.info; 
                });
            this.currentTag = 'all';

        } 

        private changeTag(tag: string) {
            this.currentTag = tag;
        }

        private selectCommand(command:string) {
            this.$modalInstance.close(command);
        }

    }
}
