namespace app.directives {

    export class HeaderMenu implements ng.IDirective {

        public restrict: string;
        public replace: boolean;
        public templateUrl: string;
        public controller: string;
        public controllerAs: string;
        public scope: boolean;

        /**
         * constructor
         *
         * @param 
         */
        constructor() {
            this.restrict = 'E';
            this.replace = true;
            this.templateUrl = 'templates/header-menu.html';
            this.controller = 'HeaderMenuController';
            this.controllerAs = 'hmc';
            this.scope = true;
        }

        /**
         * instance生成
         * @returns {function(): HeaderMenu}
         * @constructor
         */
        public static Factory(): ng.IDirectiveFactory {
            var directive = () => {
                return new HeaderMenu();
            };
            return directive;
        }
    }

    export class HeaderMenuController {

        public static $inject = ['$state'];

        private isExecution: boolean;
        private isWorkspace: boolean;
        private isHistory: boolean;

        constructor(private $state: ng.ui.IStateService) {
            this.isExecution = this.$state.current.name === 'execution';
            this.isWorkspace = this.$state.current.name === 'workspace';
            this.isHistory = this.$state.current.name === 'history';
        }

        private transit(state:string) {
            this.$state.go(state);
        }
    }
}
