namespace app.services{
    export class WebSocket {
        private socket: any;

        //public static $inject = ['$rootScope'];

        constructor(private $rootScope: ng.IRootScopeService) {
            this.socket = io.connect();
        }

        public on(eventName, callback) {
            var socket = this.socket;
            var rootScope = this.$rootScope;

            socket.on(eventName, function() {
                var args = arguments
                rootScope.$apply(function() {
                    callback.apply(socket, args)
                });
            });
        }

        public emit(eventName, data, callback) {
            var socket = this.socket;
            var rootScope = this.$rootScope;

            this.socket.emit(eventName, data, function() {
                var args = arguments
                rootScope.$apply(function() {
                    if(callback) 
                        callback.apply(socket, args)
                });
            });
        }
    }
}
