'use strict';

var express    = require('express');
var router     = express.Router()
var path       = require('path')
var formidable = require('formidable')
var db = require(__dirname + '/../../../../server/class/DB').instance;
var uuid = require('node-uuid');
var fs = require('fs');

router.post('/', function(req, res) {
    var form = new formidable.IncomingForm();
    var filesInfo = [];

    form.uploadDir = __dirname + '/../../../../user-specific-files/tmp';
    
    form.on('fileBegin', function(parentDirectory, file) {
    });
 
    form.on('error', function(err) {
        console.errro(err);
        var i = {
            status: 'error',
            message: err
        }
        res.send(i);
    });


    form.parse(req, function(err, fields, files) {
        var workspace;
        var parentDirectory = fields['parentDirectory'];
        if(process.env['NODE_ENV'] === 'debug') {
            workspace = __dirname + '/../../../../user-specific-files/workspace.debug/'; 
        } else {
            workspace = __dirname + '/../../../../user-specific-files/workspace/'; 
        }
        var promises = [];
        Object.keys(files).forEach(function(key) {
            var file = files[key];
            var fileName = file.name;
            var tmpPath = file.path;
            var info = {
                parentDirectory: parentDirectory,
                fileName: fileName,
                tmpPath: tmpPath,
                fileId: null
            };
            
            filesInfo.push(info);
            promises.push(db.createFile(fileName, parentDirectory)); // file作成に成功したらresolve, 失敗したらreject
        });

        Promise.all(promises)
        .catch(function(err) {
            filesInfo.forEach(function(fileInfo) {
                fs.unlinkSync(fileInfo.tmpPath);
            });

            var info = {
                status: 'error',
                messag: err.message
            };

            res.send(info);
        })
        .then(function(fileIds) {
            fileIds.forEach(function(fileId, i) { 
                filesInfo[i].fileId = fileId;
                fs.renameSync(filesInfo[i].tmpPath, workspace + fileId);
                delete filesInfo[i].tmpPath;
            })
            var info = {
                status: 'success',
                info: filesInfo
            };
            res.send(info);
        });
    });

    form.on('end', function() {
        
    });

});

module.exports = router;
