'use strict';

var express    = require('express');
var router     = express.Router()
var path       = require('path')
var ws = require(__dirname + '/../../../../server/class/WebSocket').instance;
var spawn = require('child_process').spawn;

var config = {
    cwd: ''
};

router.get('/:command', function(req, res) {
    var command = req.params.command;
    var runner = spawn(command,['-h'],config);

    runner.stderr.on('data', (data) => {
        ws.emit('console', data.toString());
    });

    runner.on('close', function() {
        res.send('/api/v1/help/'+command+' success');
    });

});

module.exports = router;
