// RunSet p[^ύX

#include "Globals.h"
#include "BlackBoardData.h"
#include "RunSetMenu.h"


RunSetMenu::RunSetMenu()
{
}

RunSetMenu::~RunSetMenu()
{
	
}


void  RunSetMenu::disp()
{
	BOOL	bPlus = true;
	
	const int CountU32BB = 5;	// f[^̐.
	AbstractU32BlackBoard*	data[CountU32BB];
	
	// ύXf[^ZbgB
	data[0] = &BBData_SpeedCount;	
	data[1] = &BBData_Kp;	
	data[2] = &BBData_Kd;	
	data[3] = &BBData_RightGoalCount;
	data[4] = &BBData_LeftGoalCount;
//	data[5] = &BBData_Kp2;	

	
	for( int iLoop = 0; iLoop<CountU32BB; iLoop ++ )
	{
		waitOff();

		// ύXΏۂ̃f[^𑝂₷̂炷̂IĂB
		lcd.clear();
		lcd.putf("sn",data[iLoop]->getName() );
		lcd.putf("dn",data[iLoop]->inspect() );	
		lcd.putf("sn", "----------------" );
		lcd.putf("sn", "Mode Select" );
		lcd.putf("sn", "push [] Decrease" );
		lcd.putf("sn", "push |> Increase" );
		lcd.disp();

		for( ;; )
		{
			if(Nxt::ENTR_ON  == nxt.getButtons()) // 
			{
				bPlus = false;
				break;
			}
			else if( Nxt::RUN_ON  == nxt.getButtons()) // E
			{
				bPlus = true;
				break;
			}
			
			clock.sleep( 100 );
		}
		
		
		// ݂̒l\B
		// E{^́AL̑IɂZ͌ZsB
		// {^́Ãf[^܂́ARunSetMenȕIB
		lcd.clear();
		lcd.putf("sn",data[iLoop]->getName() );
		lcd.putf("dn",data[iLoop]->inspect() );	

		lcd.putf("sn", "push [] Next" );

		if( bPlus )
		{
			lcd.putf("sn", "push |> Increase" );
		}
		else
		{
			lcd.putf("sn", "push |> Decrease" );
		}

		lcd.disp();

		// nee҂
		waitOff();

		for(;;)
		{
			
			if( bPlus )
			{

				if(Nxt::ENTR_ON  == nxt.getButtons())
				{
					// nee҂
					waitOff();

					break;

				}
				// E{^B
				else if( Nxt::RUN_ON  == nxt.getButtons())
				{
					// Z
					data[iLoop]->addUpdate();

					// ݂̒l\B
					lcd.clear();
					lcd.putf("sn",data[iLoop]->getName() );
					lcd.putf("dn",data[iLoop]->inspect() );	
					lcd.putf("sn", "push [] Next" );
					lcd.putf("sn", "push |> Increase" );
					lcd.disp();

					// nee҂
					waitOff();
				}
			}
			else
			{

				if(Nxt::ENTR_ON  == nxt.getButtons())
				{
					break;

					// nee҂
					waitOff();

				}
				// E{^B
				else if( Nxt::RUN_ON  == nxt.getButtons())
				{
					// Z
					data[iLoop]->decUpdate();

					// ݂̒l\B
					lcd.clear();
					lcd.putf("sn",data[iLoop]->getName() );
					lcd.putf("dn",data[iLoop]->inspect() );	
					lcd.putf("sn", "push [] Next   " );
					lcd.putf("sn", "push |> Decrease" );
					lcd.disp();

					// nee҂
					waitOff();

				}
			}
		}
		switch (iLoop){
		case (0):
			blackboard.setSpeed(BBData_SpeedCount.inspect());
		case (1):
			blackboard.setP(BBData_Kp.inspect()/10);
		case (2):
			blackboard.setD(BBData_Kd.inspect()/10);
		case (3):
			blackboard.setGoalCount(IDLineTraceRightSection,(S32)BBData_RightGoalCount.inspect());
		case (4):
			blackboard.setGoalCount(IDLineTraceLeftSection,(S32)BBData_LeftGoalCount.inspect());
		default:;
		}
	}

	waitOff();

}

