///////////////////////////////////////////////////////////
//  UIFactory.cpp
//  Implementation of the Class UIFactory
//  Created on:      26-7-2009 20:12:58
//  Original author: m-inui
///////////////////////////////////////////////////////////

#include "UIFactory.h"

#include "UIController.h"
#include "CalibrateController.h"
#include "CalibrateModel.h"
#include "CalibrateView.h"
#include "DriveController.h"
#include "DriveModel.h"
#include "DriveView.h"
#include "MenuController.h"
#include "MenuModel.h"
#include "MenuView.h"

#include "Test.h"

// このファクトリで生成するインスタンス
UIController        uiController;

char dispData[DISP_WIDTH][DISP_HEIGHT] = {' '};

CalibrateModel      calibrateModel(dispData);
CalibrateView       calibrateView(&calibrateModel);
CalibrateController calibrateContoller(&calibrateModel);

DriveModel          driveModel(dispData);
DriveView           driveView(&driveModel);
DriveController     driveContoller(&driveModel);

MenuModel           menuModel(dispData);
MenuView            menuView(&menuModel);
MenuController      menuContoller(&menuModel);

UIFactory::UIFactory(){

}


UIFactory::~UIFactory(){

}


UIState* UIFactory::createCalibrate(){
	calibrateContoller.initialization();
	return  &calibrateContoller;
}



UIState* UIFactory::createDrive(){
	driveContoller.initialization();
	return  &driveContoller;
}


UIState* UIFactory::createMenu(){
	menuContoller.initialization();
	return  &menuContoller;
}




UIController* UIFactory::createUIController(){

	calibrateContoller.set(this,&uiController);
	driveContoller.set(this,&uiController);
	menuContoller.set(this,&uiController);

	menuModel.set(&menuContoller);
	menuModel.set(&menuView);
	calibrateModel.set(&calibrateContoller);
	calibrateModel.set(&calibrateView);
	driveModel.set(&driveContoller);
	driveModel.set(&driveView);

	calibrateContoller.initialization();
	driveContoller.initialization();
	menuContoller.initialization();

	uiController.change(&menuContoller);

	return  &uiController;
}

