///////////////////////////////////////////////////////////
//  MenuController.cpp
//  Implementation of the Class MenuController
//  Created on:      12-7-2009 9:29:41
//  Original author: m-inui
///////////////////////////////////////////////////////////
#include <iostream>
#include <cstring>

#include "MenuController.h"
#include "Nxt.h"
#include "UIFactory.h"
#include "UIController.h"
#include "Test.h"


const char CALIBE_MODE[] = "Calibrate Mode";
const char DRIVE_MODE[]  = "Drive Mode";

MenuController::MenuController(MenuModel* menuModel):
	m_MenuModel(menuModel),m_Menu(ECalibrate)
{
}


MenuController::~MenuController(){

}


void MenuController::notifyChange(Nxt::eButton button){ 
	MenuData menuData = m_MenuModel->getData();
	Test test;
	switch(m_Menu){
	case ECalibrate:
		switch(button){
		case Nxt::ENTR_ON:
			m_nextState = m_UIFactory->createCalibrate();
			break;
		case Nxt::RUN_ON:
			m_Menu = EDrive;
//			test.disp(DRIVE_MODE);
			menuData.m_String = DRIVE_MODE;
			m_MenuModel->setData(menuData);
//			test.tone(440U,500U,30U);
			break;
		case Nxt::RUN_ENTR_ON:
//			test.tone(200U,500U,30U);
			m_Menu = ECalibrate;
			menuData.m_String = CALIBE_MODE;
			m_MenuModel->setData(menuData);
			break;
		case Nxt::BUTTONS_OFF:
			break;
		default:;
		}
		break;
	case EDrive:
		switch(button){
		case Nxt::ENTR_ON:
			m_nextState = m_UIFactory->createDrive();
			break;
		case Nxt::RUN_ON:
			m_Menu = ECalibrate;
			menuData.m_String = CALIBE_MODE;
			m_MenuModel->setData(menuData);
//			test.tone(220U,500U,30U);
			break;
		case Nxt::RUN_ENTR_ON:
			m_Menu = ECalibrate;
			menuData.m_String = CALIBE_MODE;
			m_MenuModel->setData(menuData);
			break;;
		case Nxt::BUTTONS_OFF:
			break;
		default:;
		}
	default:;
	}
	m_MenuModel->service();
}


void MenuController::update(){
	m_UIController->change(m_nextState);
}

void MenuController::initialization(){
//	Test tone(440U,500U,30U);
/*
	m_Menu = ECalibrate;
	MenuData menuData = m_MenuModel->getData();
	lcd.putf("sn", " R R L P G ");
	lcd.putf("sn", " u u i I y ");
	lcd.putf("sn", " n n g D r ");
	lcd.putf("sn", "   | h | o ");
	lcd.putf("sn", "   S t S   ");
	lcd.putf("sn", "   e   e   ");
	lcd.putf("sn", "   t   t   ");
	char (*d)[DISP_HEIGHT] = menuData.m_DispData;
	d[1][1] = 
	menuData.m_String = CALIBE_MODE;
	m_MenuModel->setData(menuData);
*/	
}

