
#include "Globals.h"
#include "ControlFactory.h"
#include "BlackBoardController.h"
#include "RallyDriver.h"
#include "ConcreteDTech.h"
#include "StandingDTech.h"
#include "LineTraceLeftDTech.h"
#include "LineTraceRightDTech.h"
#include "PID.h"


// ̃t@NgŐCX^X
BlackBoardController	blackboardController(blackboard);
Navigator				navigator;
RallyDriver				rallyDriver;	// 0808 ߂B
PID						pid(blackboard);
ConcreteDTech			concreteDTech(nxt, gyro, leftMotor, rightMotor, blackboard, pid);
StandingDTech			standingDTech(nxt, gyro, leftMotor, rightMotor, blackboard, pid);
LineTraceLeftDTech		lineTraceLeftDTech(nxt, gyro, leftMotor, rightMotor, blackboard, pid);
LineTraceRightDTech		lineTraceRightDTech(nxt, gyro, leftMotor, rightMotor, blackboard, pid);


ControlFactory::ControlFactory() {
}


ControlFactory::~ControlFactory() {
}

void ControlFactory::create() {
	// eRg[ŗL̏B
	// Rg[Ԃ̊֘AtB Ŏ{B
	rallyDriver.setNavigator(&navigator);
	
	rallyDriver.setDTech(IDConcreteDTech, &concreteDTech);
	rallyDriver.setDTech(IDStandingDTech, &standingDTech);
	rallyDriver.setDTech(IDLineTraceLeftDTech, &lineTraceLeftDTech);
	rallyDriver.setDTech(IDLineTraceRightDTech, &lineTraceRightDTech);

	// Control͉LŔzuB
	controls[IControl::BLACKBOARD_CONTROLLER]	= &blackboardController;
	controls[IControl::RALLY_DRIVER] 			= &rallyDriver;
}

// -----------------------------------------
// j[擾B
IControl* ControlFactory::getControl( U8 index ) {
	return controls[index];
}

