///////////////////////////////////////////////////////////
//  PID.h
//  Implementation of the Class PID
//  Created on:      11-7-2009 20:33:36
//  Original author: m-usami
///////////////////////////////////////////////////////////

#if !defined(EA_777386C3_E5B9_425e_9B40_52F6D7705341__INCLUDED_)
#define EA_777386C3_E5B9_425e_9B40_52F6D7705341__INCLUDED_

#include "ecrobot_types.h"
#include "ControlAlgorithm.h"

class PID : public ControlAlgorithm {
	static const S8 MAX = 100;	// l̍ől
	static const S8 MIN = -100;	// l̍ŏl
	static const F32 KD = -2.0;	// QC
	static const F32 KP_WIDTH = 1.0;// QC
	static const S8 VELOCITY = 80;	// x̏l

	F32 upper_, lower_;		// ̒l, O[̒l, ̒l
	F32 threashold_;		// ̖ڕWli臒lj
	F32 kp_, kpWidth_;		// ᐧQC
	F32 kd_;			// QC
	S16 m_preLight;			// ZT[l̑Ol
	S8 m_velocity;

	S8 getDirectionCommand(S16 light);
	S8 getVelocityCommand(S16 light);
public:
	PID(LightSensorValue& bb);
	virtual ~PID();

	F32  getThreashold();
	void setThreashold(F32 threadshold);
	void setVelocity(S8 velocity);

	virtual void init();
	virtual void getCommand(S16 light, S8& direction, S8& velocity);
};
#endif // !defined(EA_777386C3_E5B9_425e_9B40_52F6D7705341__INCLUDED_)
