///////////////////////////////////////////////////////////
//  LightSensorValue.h
//  Implementation of the Class LightSensorValue
//  Created on:      11-7-2009 18:13:37
//  Original author: Administrator
///////////////////////////////////////////////////////////

#if !defined(EA_E133B48D_949D_4d4d_B0FB_E31A34070F9A__INCLUDED_)
#define EA_E133B48D_949D_4d4d_B0FB_E31A34070F9A__INCLUDED_

// T.B.D
#include "LightSensor.h"
#include "LIGHT_SENSOR_CONDITION.h"
#include "SectionID.h"


class LightSensorValue
{
	const ecrobot::LightSensor& m_Light;
	S16 white;
	S16 black;
	S16 gray;

	S32 direction;
	S8 moter[2];

	S8 speed;
	F32 p;
	F32 d;

	F32 threshold;

	enum SectionID startNavigator;
	S32 goalCount[MAX_SectionID];


public:
	LightSensorValue(ecrobot::LightSensor& light);
	virtual ~LightSensorValue();
	LIGHT_SENSOR_CONDITION value;

	// ZT̎擾F
	S16 getWhite();
	void setWhite(S16 v);

	// ZT̎擾F
	S16 getBlack();
	void setBlack(S16 v);

	// ZT̎擾DF
	S16 getGray();
	void setGray(S16 v);

	// bc()ɗ^
	S32 getDirection();
	void setDirection(S32 v);

	// bc()瓾[^ւ̎w
	S8 getMoterDriveValue(S8 rl);
	void setMoterDriveValue(S8 rl, S8 v);

	// xݒ
	S8 getSpeed();
	void setSpeed(S8 v);

	// PIDP
	F32 getP();
	void setP(F32 v);

	// PIDD
	F32 getD();
	void setD(F32 v);

	// ZT擾l̖ڕW
	F32 getThreshold();
	void setThreshold(F32 v);

	// sJnɎgpSection
	enum SectionID getStartNavigator();
	void setStartNavigator(enum SectionID v);

	// esSectionɁA~ݒ
	S32 getGoalCount(enum SectionID n);
	void setGoalCount(enum SectionID n, S32 v);

//	LIGHT_SENSOR_CONDITION inspect();
	S16 inspect();
	void update();

};
#endif // !defined(EA_E133B48D_949D_4d4d_B0FB_E31A34070F9A__INCLUDED_)
