/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class Rectangle
extends Rectangle2D
implements Shape {
    public int height;
    public int width;
    public int x;
    public int y;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle() {
        this(0, 0);
    }

    public Rectangle(Point p) {
        this(p.x, p.y, 0, 0);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(Rectangle r) {
        if (this.isEmpty() || r.isEmpty()) {
            return false;
        }
        return this.contains(r.x, r.y) && this.contains(r.x + r.width, r.y + r.height);
    }

    public boolean intersects(Rectangle r) {
        int tw = this.width;
        int th = this.height;
        int rw = r.width;
        int rh = r.height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        int rx = r.x;
        int ry = r.y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setRect(double x, double y, double width, double height) {
        int newh;
        int newy;
        int neww;
        int newx;
        if (x > 4.294967294E9) {
            newx = Integer.MAX_VALUE;
            neww = -1;
        } else {
            newx = Rectangle.doubleToInt(x, false);
            if (width >= 0.0) {
                width += x - (double)newx;
            }
            neww = Rectangle.doubleToInt(width, width >= 0.0);
        }
        if (y > 4.294967294E9) {
            newy = Integer.MAX_VALUE;
            newh = -1;
        } else {
            newy = Rectangle.doubleToInt(y, false);
            if (height >= 0.0) {
                height += y - (double)newy;
            }
            newh = Rectangle.doubleToInt(height, height >= 0.0);
        }
        this.reshape(newx, newy, neww, newh);
    }

    @Deprecated
    public void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    private static int doubleToInt(double x, boolean high) {
        if (x <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (x >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(high ? Math.ceil(x) : Math.floor(x));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    @Deprecated
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "Rectangle[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public int outcode(double x, double y) {
        int out = 0;
        if (this.width <= 0) {
            out |= 5;
        } else if (x < (double)this.x) {
            out |= 1;
        } else if (x > (double)this.x + (double)this.width) {
            out |= 4;
        }
        if (this.height <= 0) {
            out |= 0xA;
        } else if (y < (double)this.y) {
            out |= 2;
        } else if (y > (double)this.y + (double)this.height) {
            out |= 8;
        }
        return out;
    }

    @Deprecated
    public boolean inside(int x, int y) {
        int w = this.width;
        int h = this.height;
        if (w < 0 || h < 0) {
            return false;
        }
        if (x < this.x || y < this.y) {
            return false;
        }
        h += this.y;
        return !((w += this.x) >= this.x && w <= x || h >= this.y && h <= y);
    }
}

