/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class InputStream {
    private static final int SKIP_BUF_LEN = 32;

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        int end = off + len;
        int origoff = off;
        b[off++] = (byte)c;
        while (off < end && this.available() > 0) {
            c = this.read();
            if (c < 0) {
                return -1;
            }
            b[off++] = (byte)c;
        }
        return off - origoff;
    }

    public long skip(long n) throws IOException {
        int readlen;
        int len;
        byte[] buffer = new byte[32];
        long nbackup = n;
        while (n > 0L && (len = this.read(buffer, 0, readlen = n >= 32L ? 32 : (int)n)) >= 0) {
            n -= (long)len;
        }
        return nbackup - n;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

