/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final int MAX_EXPONENT = 127;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final int MIN_EXPONENT = -126;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int SIZE = 32;
    public static final Class<?> TYPE = null;
    private float value;

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(String s) {
        this.value = Float.parseFloat(s);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)o).value);
    }

    public static native int floatToRawIntBits(float var0);

    public static int floatToIntBits(float value) {
        int i = Float.floatToRawIntBits(value);
        int j = i & Integer.MAX_VALUE;
        if (j >= 2139095041 && j <= Integer.MAX_VALUE) {
            i = 2143289344;
        }
        return i;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public static native float intBitsToFloat(int var0);

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float v) {
        return v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float val) {
        return val != val;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static float parseFloat(String s) throws NumberFormatException {
        return StringUtils.stringToFloat(s);
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(float f) {
        return String.valueOf(f);
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static Float valueOf(String s) {
        return new Float(s);
    }
}

