/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.io.IOException;
import javax.microedition.io.Connection;
import lejos.nxt.comm.BTConnection;
import lejos.nxt.comm.Bluetooth;

public class RemoteDevice {
    private String addr;
    private String friendlyName;
    private byte[] deviceClass = new byte[4];

    protected RemoteDevice(String addr) {
        this.addr = addr;
        this.getFriendlyName(true);
    }

    public RemoteDevice(String name, String deviceAddr, byte[] devclass) {
        this.setFriendlyName(name);
        this.setDeviceAddr(deviceAddr);
        this.setDeviceClass(devclass);
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        BTConnection btc = (BTConnection)conn;
        return new RemoteDevice(btc.getAddress());
    }

    public void setDeviceAddr(String deviceAddr) {
        this.addr = deviceAddr;
    }

    public String getDeviceAddr() {
        return this.addr;
    }

    public void setFriendlyName(String fName) {
        this.friendlyName = fName;
    }

    public boolean isAuthenticated() {
        return !this.friendlyName.equals("");
    }

    public boolean isEncrypted() {
        return false;
    }

    public String getFriendlyName(boolean alwaysAsk) {
        if (alwaysAsk) {
            this.friendlyName = Bluetooth.lookupName(this.addr);
        }
        return this.friendlyName;
    }

    public void setDeviceClass(byte[] devclass) {
        for (int i = 0; i < 4; ++i) {
            this.deviceClass[i] = devclass[i];
        }
    }

    public String getBluetoothAddress() {
        return this.addr;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof RemoteDevice && ((RemoteDevice)obj).getBluetoothAddress().equals(this.getBluetoothAddress());
    }

    public byte[] getDeviceClass() {
        return this.deviceClass;
    }
}

