/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;
import lejos.nxt.Sound;

public class Alert
extends Screen {
    private final Command DISMISS_COMMAND = new Command(0, 1, 0);
    public static final int FOREVER = -2;
    public static final int ALERT_TYPE_INFO = 0;
    public static final int ALERT_TYPE_WARNING = 1;
    public static final int ALERT_TYPE_ERROR = 2;
    public static final int ALERT_TYPE_ALARM = 3;
    public static final int ALERT_TYPE_CONFIRMATION = 4;
    public static final String STR_CONFIRM = "Yes";
    public static final String STR_DENY = "No";
    public static final Image IMG_INFO = new Image(16, 16, new byte[]{-32, 16, 12, 4, 2, 1, 73, -35, -35, 73, 1, 2, 4, 12, 16, -32, 7, 8, 48, 32, 64, -128, -96, -65, -65, -96, -128, 64, 32, 48, 8, 7});
    public static final Image IMG_WARNING = new Image(16, 16, new byte[]{-32, 16, 12, 4, 2, 1, 125, -3, -3, 125, 1, 2, 4, 12, 16, -32, 7, 8, 48, 32, 64, -128, -112, -69, -69, -112, -128, 64, 32, 48, 8, 7});
    public static final Image IMG_ERROR = new Image(16, 16, new byte[]{-32, 16, 12, 4, 18, 57, 97, -63, -63, 97, 57, 18, 4, 12, 16, -32, 7, 8, 48, 32, 72, -100, -122, -125, -125, -122, -100, 72, 32, 48, 8, 7});
    public static final Image IMG_ALARM = new Image(16, 16, new byte[]{-32, 16, 12, 4, -14, -7, -3, -3, -3, -3, -7, -14, 4, 12, 16, -32, 7, 8, 48, 36, 71, -121, -113, -97, -97, -113, -121, 71, 36, 48, 8, 7});
    public static final Image IMG_CONFIRM = new Image(16, 16, new byte[]{-32, 16, 12, 4, 18, 57, 13, 13, -115, -51, 121, 50, 4, 12, 16, -32, 7, 8, 48, 32, 64, -128, -112, -69, -69, -112, -128, 64, 32, 48, 8, 7});
    static Image[] icons = new Image[]{IMG_INFO, IMG_WARNING, IMG_ERROR, IMG_ALARM, IMG_CONFIRM};
    String text;
    Image image;
    Gauge gauge;
    int type;
    int time;
    boolean confirm = false;

    public Alert(String title) {
        this.title = title;
        this.time = -2;
        this.commands.add(this.DISMISS_COMMAND);
    }

    public Alert(String title, String alertText, Image alertImage, int alertType) {
        this.title = title;
        this.text = alertText;
        this.image = alertImage;
        this.type = alertType;
        this.time = -2;
        this.commands.add(this.DISMISS_COMMAND);
    }

    public void setType(int alertType) {
        this.type = alertType;
    }

    public void setString(String alertText) {
        this.text = alertText;
    }

    public void setTimeout(int time) {
        this.time = time;
    }

    public int getTimeout() {
        return this.time;
    }

    public boolean getConfirmation() {
        return this.confirm;
    }

    public void setIndicator(Gauge indicator) {
        if (indicator.isInteractive() || indicator.label != null) {
            throw new IllegalArgumentException();
        }
        this.gauge = indicator;
    }

    public Gauge getIndicator() {
        return this.gauge;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 38 && this.cmdListener != null) {
            this.cmdListener.commandAction(this.DISMISS_COMMAND, this);
        } else if (this.type == 4) {
            if (keyCode == 37) {
                this.confirm = false;
            } else if (keyCode == 39) {
                this.confirm = true;
            }
            this.repaint();
        }
    }

    protected void showNotify() {
        new Thread(){

            public void run() {
                Sound.beepSequenceUp();
            }
        }.start();
        this.repaint();
    }

    public void paint(Graphics g) {
        int line = 8;
        int ch = 6;
        g.drawImage(null, 0, 0, 0, 0, 100, 16, 85);
        g.drawString(this.title, g.getCenteredX(this.title), line / 2, true);
        if (this.image != null) {
            g.drawImage(this.image, 0, 20, false);
        } else {
            g.drawImage(icons[this.type], 0, 20, false);
        }
        g.drawString(this.text, 3 * ch, 3 * line);
        if (this.type == 4) {
            g.drawString(this.confirm ? STR_CONFIRM : STR_DENY, g.getCenteredX(STR_CONFIRM), 4 * line, true);
        } else if (this.gauge != null) {
            this.gauge.paint(g, 0, 32, 100, 32, false);
        }
    }
}

