/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;
import lejos.nxt.Button;
import lejos.nxt.ButtonListener;
import lejos.util.Delay;
import lejos.util.Timer;
import lejos.util.TimerListener;

public class Display {
    private static final int TICKER_INTERVAL_MSEC = 100;
    public static final int SCREEN_WIDTH = 100;
    public static final int SCREEN_HEIGHT = 64;
    public static final int CHAR_WIDTH = 6;
    public static final int CHAR_HEIGHT = 8;
    public static final int SCREEN_CHAR_WIDTH = 16;
    public static final int SCREEN_CHAR_DEPTH = 8;
    private static Display display;
    private Screen current;
    private Screen alertBackup;
    private int alertTimeout;
    private Timer tickerTimer;
    private int tickerOffset = 100;
    protected Graphics graphics = new Graphics();
    private boolean quit;

    private Display() {
        this.graphics.autoRefresh(false);
    }

    public static Display getDisplay() {
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public void setCurrent(Screen nextDisplayable) {
        if (nextDisplayable != null) {
            if (nextDisplayable instanceof Alert) {
                if (this.alertBackup == null) {
                    this.alertBackup = this.current;
                }
                int n = this.alertTimeout = ((Alert)nextDisplayable).getTimeout() == -2 ? -2 : (int)System.currentTimeMillis() + ((Alert)nextDisplayable).getTimeout();
            }
            if (this.current != null) {
                this.current.hideNotify();
            }
            this.tickerOffset = 100;
            this.current = nextDisplayable;
            this.current.showNotify();
            this.current.repaint();
        }
    }

    public void setCurrent(Alert alert, Screen nextDisplayable) {
        if (alert != null && nextDisplayable != null) {
            this.alertBackup = nextDisplayable;
            if (this.current != null) {
                this.current.hideNotify();
            }
            this.alertTimeout = alert.getTimeout() == -2 ? -2 : (int)System.currentTimeMillis() + alert.getTimeout();
            this.tickerOffset = 100;
            this.current = alert;
            this.current.showNotify();
            this.current.repaint();
        }
    }

    public Displayable getCurrent() {
        return this.current;
    }

    public void show(boolean polling) {
        if (!polling) {
            this.showUsingListeners();
            return;
        }
        int tsTickerUpdate = (int)System.currentTimeMillis();
        while (!this.quit) {
            while (!this.quit && Button.readButtons() > 0) {
                Thread.yield();
            }
            while (!this.quit && Button.readButtons() == 0) {
                if (this.msecPassed(tsTickerUpdate)) {
                    int tickerLen = this.updateTicker(this.tickerOffset);
                    if (tickerLen > 0) {
                        --this.tickerOffset;
                        if (this.tickerOffset < -tickerLen) {
                            this.tickerOffset = 100;
                        }
                    }
                    tsTickerUpdate = (int)System.currentTimeMillis() + 100;
                }
                if (this.current != null && this.current instanceof Alert && this.alertTimeout != -2 && this.msecPassed(this.alertTimeout)) {
                    this.current.hideNotify();
                    this.current = this.alertBackup;
                    this.alertBackup = null;
                }
                this.update();
                Thread.yield();
            }
            if (this.current == null) continue;
            Delay.msDelay(20L);
            int btnPressed = Button.readButtons();
            if (btnPressed == 1) {
                if (this.current instanceof Alert) {
                    Screen saved = this.current;
                    this.current.keyPressed(38);
                    if (saved == this.current) {
                        this.current.hideNotify();
                        this.current = this.alertBackup;
                        this.alertBackup = null;
                    }
                } else {
                    this.current.keyPressed(38);
                }
                this.update();
                continue;
            }
            if (btnPressed == 2) {
                this.current.keyPressed(37);
                this.update();
                continue;
            }
            if (btnPressed == 4) {
                this.current.keyPressed(39);
                this.update();
                continue;
            }
            if (btnPressed != 8) continue;
            this.current.keyPressed(40);
            this.update();
        }
        System.exit(0);
    }

    public void quit() {
        this.quit = true;
    }

    private void showUsingListeners() {
        Button.ENTER.addButtonListener(new ButtonListener(){

            public void buttonReleased(Button b) {
            }

            public void buttonPressed(Button b) {
                if (Display.this.current != null) {
                    if (Display.this.current instanceof Alert) {
                        Screen saved = Display.this.current;
                        Display.this.current.keyPressed(38);
                        if (saved == Display.this.current) {
                            Display.this.current.hideNotify();
                            Display.this.current = Display.this.alertBackup;
                            Display.this.alertBackup = null;
                        }
                    } else {
                        Display.this.current.keyPressed(38);
                    }
                    Display.this.update();
                }
            }
        });
        Button.ESCAPE.addButtonListener(new ButtonListener(){

            public void buttonReleased(Button b) {
            }

            public void buttonPressed(Button b) {
                if (Display.this.current != null) {
                    Display.this.current.keyPressed(40);
                    Display.this.update();
                }
            }
        });
        Button.LEFT.addButtonListener(new ButtonListener(){

            public void buttonReleased(Button b) {
            }

            public void buttonPressed(Button b) {
                if (Display.this.current != null) {
                    Display.this.current.keyPressed(37);
                    Display.this.update();
                }
            }
        });
        Button.RIGHT.addButtonListener(new ButtonListener(){

            public void buttonReleased(Button b) {
            }

            public void buttonPressed(Button b) {
                if (Display.this.current != null) {
                    Display.this.current.keyPressed(39);
                    Display.this.update();
                }
            }
        });
        this.tickerTimer = new Timer(100, new TimerListener(){

            public void timedOut() {
                int tickerLen = Display.this.updateTicker(Display.this.tickerOffset);
                if (tickerLen > 0) {
                    Display.this.tickerOffset--;
                    if (Display.this.tickerOffset < -tickerLen) {
                        Display.this.tickerOffset = 100;
                    }
                }
            }
        });
        this.tickerTimer.start();
        new Timer(50, new TimerListener(){

            public void timedOut() {
                if (Display.this.current != null && Display.this.current instanceof Alert && Display.this.alertTimeout != -2 && Display.this.msecPassed(Display.this.alertTimeout)) {
                    Display.this.current.hideNotify();
                    Display.this.current = Display.this.alertBackup;
                    Display.this.alertBackup = null;
                }
                if (Display.this.quit) {
                    System.exit(0);
                }
                Display.this.update();
            }
        }).start();
    }

    private synchronized void update() {
        if (this.current.getPaintRequest()) {
            this.graphics.clear();
            this.updateTicker(this.tickerOffset);
            this.current.paint(this.graphics);
            this.current.clearPaintRequest();
            this.graphics.refresh();
        }
    }

    private int updateTicker(int offset) {
        Ticker ticker = this.current.getTicker();
        if (ticker != null) {
            int old = this.graphics.getColor();
            this.graphics.setColor(0);
            this.graphics.fillRect(0, 0, 100, 8);
            this.graphics.setColor(old);
            this.graphics.drawString(ticker.getString(), offset, 0);
            this.graphics.refresh();
            return ticker.getString().length() * 6;
        }
        return 0;
    }

    private boolean msecPassed(int ts) {
        return (int)System.currentTimeMillis() - ts > 0;
    }
}

