/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import javax.microedition.location.AddressInfo;
import javax.microedition.location.QualifiedCoordinates;

public class Location {
    private float speed = -1.0f;
    private float course = -1.0f;
    private long timeStamp = -1L;
    private String extraInfo = null;
    private int locationMethod = -1;
    private QualifiedCoordinates qc = null;
    public static final int MTA_ASSISTED = 262144;
    public static final int MTA_UNASSISTED = 524288;
    public static final int MTE_ANGLEOFARRIVAL = 32;
    public static final int MTE_CELLID = 8;
    public static final int MTE_SATELLITE = 1;
    public static final int MTE_SHORTRANGE = 16;
    public static final int MTE_TIMEDIFFERENCE = 2;
    public static final int MTE_TIMEOFARRIVAL = 4;
    public static final int MTY_NETWORKBASED = 131072;
    public static final int MTY_TERMINALBASED = 65536;

    protected Location(QualifiedCoordinates coords, float speed, float course, long timeStamp, int locationMethod, String extraInfo) {
        this.qc = coords;
        this.setSpeed(speed);
        this.setCourse(course);
        this.timeStamp = timeStamp;
        this.locationMethod = locationMethod;
        this.extraInfo = extraInfo;
    }

    public AddressInfo getAddressInfo() {
        return null;
    }

    public float getCourse() {
        return this.course;
    }

    public String getExtraInfo(String mimetype) {
        return this.extraInfo;
    }

    public int getLocationMethod() {
        return this.locationMethod;
    }

    public QualifiedCoordinates getQualifiedCoordinates() {
        return this.qc;
    }

    public float getSpeed() {
        return this.speed;
    }

    public long getTimestamp() {
        return this.timeStamp;
    }

    public boolean isValid() {
        return !(this.course < 0.0f | this.speed < 0.0f | this.qc == null);
    }

    protected void setCourse(float course) throws IllegalArgumentException {
        if (course < 0.0f | course > 360.0f) {
            throw new IllegalArgumentException("course outside 0-360");
        }
        this.course = course;
    }

    protected void setSpeed(float speed) throws IllegalArgumentException {
        if (speed < 0.0f) {
            throw new IllegalArgumentException("speed can't be negative");
        }
        this.speed = speed;
    }
}

