/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import lejos.addon.gps.GGASentence;
import lejos.addon.gps.GPSListener;
import lejos.addon.gps.GSASentence;
import lejos.addon.gps.NMEASentence;
import lejos.addon.gps.VTGSentence;

public class SimpleGPS
extends Thread {
    private final int BUFF = 20;
    private byte[] segment = new byte[20];
    private StringBuffer currentSentence = new StringBuffer();
    private String START_CHAR = "$";
    private InputStream in;
    public int errors = 0;
    protected GGASentence ggaSentence;
    protected VTGSentence vtgSentence;
    private GSASentence gsaSentence;
    private StringTokenizer tokenizer;
    private boolean shutdown = false;
    protected static Vector listeners = new Vector();

    public SimpleGPS(InputStream in) {
        this.in = in;
        this.ggaSentence = new GGASentence();
        this.vtgSentence = new VTGSentence();
        this.gsaSentence = new GSASentence();
        this.setDaemon(true);
        this.start();
    }

    public double getLatitude() {
        return this.ggaSentence.getLatitude();
    }

    public char getLatitudeDirection() {
        return this.ggaSentence.getLatitudeDirection();
    }

    public double getLongitude() {
        return this.ggaSentence.getLongitude();
    }

    public char getLongitudeDirection() {
        return this.ggaSentence.getLongitudeDirection();
    }

    public float getAltitude() {
        return this.ggaSentence.getAltitude();
    }

    public int getSatellitesTracked() {
        return this.ggaSentence.getSatellitesTracked();
    }

    public int getFixMode() {
        return this.ggaSentence.getFixQuality();
    }

    public int getTimeStamp() {
        return this.ggaSentence.getTime();
    }

    public float getSpeed() {
        return this.vtgSentence.getSpeed();
    }

    public float getCourse() {
        return this.vtgSentence.getTrueCourse();
    }

    public String getSelectionType() {
        return this.gsaSentence.getMode();
    }

    public int getFixType() {
        return this.gsaSentence.getModeValue();
    }

    public int[] getPRN() {
        return this.gsaSentence.getPRN();
    }

    public float getPDOP() {
        return this.gsaSentence.getPDOP();
    }

    public float getHDOP() {
        return this.gsaSentence.getHDOP();
    }

    public float getVDOP() {
        return this.gsaSentence.getVDOP();
    }

    public void close() throws IOException {
        this.shutdown = true;
        this.in.close();
    }

    public void run() {
        while (!this.shutdown) {
            String s = this.getNextString();
            if (s.indexOf(42) < 0 || s.indexOf(36) < 0) continue;
            try {
                if (!NMEASentence.isValid(s)) continue;
                this.tokenizer = new StringTokenizer(s);
                String token = this.tokenizer.nextToken();
                this.sentenceChooser(token, s);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.err.println("SimpleGPS.run() error. StringIndexOutOfBounds");
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                System.err.println("SimpleGPS.run() error. ArrayIndexOutOfBounds");
            }
        }
    }

    protected void sentenceChooser(String header, String s) {
        if (header.equals("$GPGGA")) {
            this.ggaSentence.setSentence(s);
            SimpleGPS.notifyListeners(this.ggaSentence);
        } else if (header.equals("$GPVTG")) {
            this.vtgSentence.setSentence(s);
            SimpleGPS.notifyListeners(this.vtgSentence);
        } else if (header.equals("$GPGSA")) {
            this.gsaSentence.setSentence(s);
            SimpleGPS.notifyListeners(this.gsaSentence);
        }
    }

    protected static void notifyListeners(NMEASentence sen) {
        for (int i = 0; i < listeners.size(); ++i) {
            GPSListener gpsl = (GPSListener)listeners.elementAt(i);
            gpsl.sentenceReceived(sen);
        }
    }

    private String getNextString() {
        boolean done = false;
        String sentence = "";
        int endIndex = 0;
        do {
            try {
                this.in.read(this.segment);
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < 20; ++i) {
                this.currentSentence.append((char)this.segment[i]);
            }
            if (this.currentSentence.indexOf(this.START_CHAR, 1) >= 0) {
                done = true;
            }
            if (this.currentSentence.length() < 500) continue;
            ++this.errors;
            System.err.println("Bug in SimpleGPS.getNextString() detected. > 500");
            System.err.println("Sentence: " + this.currentSentence.toString());
            return null;
        } while (!done);
        try {
            endIndex = this.currentSentence.indexOf(this.START_CHAR, 1);
            sentence = this.currentSentence.substring(0, endIndex);
            this.currentSentence.delete(0, endIndex);
        }
        catch (Exception e) {
            System.err.println("Exception in SimpleGPS.getNextString() " + e.getMessage());
        }
        return sentence;
    }

    public static void addListener(GPSListener listener) {
        listeners.addElement(listener);
    }

    public static void removeListener(GPSListener listener) {
        listeners.removeElement(listener);
    }
}

