/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import java.util.ArrayList;
import lejos.nxt.I2CSensor;
import lejos.nxt.SensorPort;
import lejos.nxt.addon.LDCMotor;
import lejos.nxt.addon.LServo;

public class LSC
extends I2CSensor {
    private ArrayList<LServo> arrServo;
    private ArrayList<LDCMotor> arrDCMotor;
    private final int MAXIMUM_SERVOS_DCMOTORS = 10;
    private final String ERROR_SERVO_DEFINITION = "Error with Servo definition";
    private final String ERROR_SERVO_LOCATION = "Error with Servo location";
    private byte SPI_PORT;
    private SensorPort portConnected;

    public LSC(SensorPort port, byte SPI_PORT) {
        super(port);
        this.portConnected = port;
        this.SPI_PORT = SPI_PORT;
        this.arrServo = new ArrayList();
        this.arrDCMotor = new ArrayList();
        this.setAddress(40);
    }

    public void addServo(int location, String name) throws ArrayIndexOutOfBoundsException {
        if (this.arrServo.size() > 10) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LServo s = new LServo(this.portConnected, location, name, this.SPI_PORT);
        this.arrServo.add(s);
    }

    public void addServo(int location, String name, int min_angle, int max_angle) throws ArrayIndexOutOfBoundsException {
        if (this.arrServo.size() > 10) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LServo s = new LServo(this.portConnected, location, name, this.SPI_PORT, min_angle, max_angle);
        this.arrServo.add(s);
    }

    public LServo getServo(int index) {
        return this.arrServo.get(index);
    }

    public void addDCMotor(int location, String name) throws ArrayIndexOutOfBoundsException {
        if (this.arrDCMotor.size() > 10) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LDCMotor dcm = new LDCMotor(this.portConnected, location, name, this.SPI_PORT);
        this.arrDCMotor.add(dcm);
    }

    public void addDCMotor(int location, String name, int forward_min_speed, int forward_max_speed, int backward_min_speed, int backward_max_speed) throws ArrayIndexOutOfBoundsException {
        if (this.arrDCMotor.size() > 10) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LDCMotor dcm = new LDCMotor(this.portConnected, location, name, this.SPI_PORT, forward_min_speed, forward_max_speed, backward_min_speed, backward_max_speed);
        this.arrDCMotor.add(dcm);
    }

    public LDCMotor getDCMotor(int index) {
        return this.arrDCMotor.get(index);
    }

    public void calibrate() {
        byte[] bufReadResponse = new byte[8];
        int I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
        while (bufReadResponse[0] != 99) {
            I2C_Response = this.sendData(this.SPI_PORT, (byte)-1);
            I2C_Response = this.sendData(this.SPI_PORT, (byte)-1);
            I2C_Response = this.sendData(this.SPI_PORT, (byte)126);
            I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
            I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
            if (bufReadResponse[0] != 99) continue;
            break;
        }
    }

    public void loadAllServos() {
        int channel = 1023;
        byte h_byte = -32;
        byte l_byte = (byte)channel;
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }

    public void unloadAllServos() {
        boolean channel = false;
        byte h_byte = -32;
        byte l_byte = (byte)(channel ? 1 : 0);
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }
}

