/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;
import lejos.util.Delay;

public class RFIDSensor
extends I2CSensor {
    private static final int REG_CMD = 65;
    private static final byte CMD_STOP = 0;
    private static final byte CMD_SINGLEREAD = 1;
    private static final byte CMD_CONTINUOUSREAD = 2;
    private static final byte CMD_BOOTLOADER = -127;
    private static final byte CMD_STARTFIRMWARE = -125;
    private static final int REG_STATUS = 50;
    private static final int REG_DATA = 66;
    private static final int LEN_DATA = 5;
    private static final int REG_SERIALNO = 160;
    private static final int LEN_SERIALNO = 16;
    private static final int DEFAULT_ADDRESS = 2;
    private static final int DELAY_WAKEUP = 5;
    private static final int DELAY_FIRMWARE = 100;
    private static final int DELAY_ACQUIRE = 250;
    private static final int DELAY_READ = 200;
    private byte[] buf1 = new byte[1];
    private long nextRead = this.now();

    public RFIDSensor(I2CPort port) {
        super(port);
        port.setType(11);
        this.setAddress(2);
        this.wakeUp();
        this.readTransponder(false);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void waitUntil(long target) {
        long d = target - this.now();
        if (d > 0L) {
            Delay.msDelay(d);
        }
    }

    public void wakeUp() {
        this.sendData(0, (byte)0);
        Delay.msDelay(5L);
    }

    protected String fetchString(byte register, int len) {
        this.wakeUp();
        return super.fetchString(register, len);
    }

    public void startFirmware() {
        this.sendData(65, (byte)-125);
    }

    public void startBootLoader() {
        this.sendData(65, (byte)-127);
    }

    public byte[] getSerialNo() {
        this.wakeUp();
        this.startBootLoader();
        Delay.msDelay(100L);
        byte[] ret = new byte[16];
        if (this.getData(160, ret, ret.length) < 0) {
            ret = null;
        }
        this.startFirmware();
        return ret;
    }

    public int getStatus() {
        if (this.getData(50, this.buf1, this.buf1.length) < 0) {
            return -1;
        }
        return this.buf1[0];
    }

    public int startSingleRead() {
        return this.sendData(65, (byte)1);
    }

    public int startContinuousRead() {
        return this.sendData(65, (byte)2);
    }

    public int stop() {
        return this.sendData(65, (byte)0);
    }

    public byte[] readTransponder(boolean continuous) {
        this.waitUntil(this.nextRead);
        this.wakeUp();
        if (continuous) {
            if (this.getStatus() <= 0) {
                this.startContinuousRead();
                Delay.msDelay(250L);
            }
        } else {
            this.startSingleRead();
            Delay.msDelay(250L);
        }
        this.nextRead = this.now() + 200L;
        boolean valid = false;
        byte[] ret = new byte[5];
        for (int i = 0; i < ret.length; ++i) {
            if (this.getData(66 + i, this.buf1, this.buf1.length) < 0) {
                return null;
            }
            ret[i] = this.buf1[0];
            if (this.buf1[0] == 0) continue;
            valid = true;
        }
        return (byte[])(valid ? ret : null);
    }

    public long readTransponderAsLong(boolean continuous) {
        byte[] id = this.readTransponder(continuous);
        if (id == null) {
            return 0L;
        }
        long ret = 0L;
        for (int i = id.length - 1; i >= 0; --i) {
            ret <<= 8;
            ret |= (long)id[i] & 0xFFL;
        }
        return ret;
    }
}

