/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.NXTCommConnector;
import lejos.nxt.comm.NXTCommDevice;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.RS485Connection;
import lejos.util.Delay;

public class RS485
extends NXTCommDevice {
    public static final int BUFSZ = 128;
    public static final int MAX_CONNECTIONS = 8;
    static final int CRC_CITT = 4129;
    static final int CRC_INIT = 65535;
    static final byte BB_EXTRA = 6;
    static final byte BB_FLAG = 126;
    static final byte BB_ESCAPE = 125;
    static final byte BB_XOR = 32;
    static final byte BB_SEQMASK = 7;
    static final byte BB_SNRM = -109;
    static final byte BB_DISC = 83;
    static final byte BB_UA = 115;
    static final byte BB_FRMR = -105;
    static final byte BB_IFRAME = 16;
    static final byte BB_IMASK = 17;
    static final byte BB_ACK = 17;
    static final byte BB_ACKMASK = 27;
    static final byte BB_ACKRR = 17;
    static final byte BB_ACKNR = 21;
    static final byte BB_BROADCAST = 0;
    static final byte BB_INVALID = -1;
    static final int BB_ASEQSHIFT = 5;
    static final int BB_SSEQSHIFT = 1;
    static final int BB_DATAOFFSET = 2;
    static final int BB_CSUMSZ = 2;
    static final int FRAME_TIMEOUT = 10;
    static final int REPLY_RETRY = 5;
    static final int REQUEST_RETRY = 5;
    static final int RECV_RETRY = 1000;
    static final int DS_DISABLED = 0;
    static final int DS_SLAVE = 1;
    static final int DS_MASTER = 2;
    static final int ST_FLAG = 0;
    static final int ST_ESCAPE = 1;
    static final int ST_DATA = 2;
    static Controller controller = new Controller();
    static NXTCommConnector connector = null;

    private RS485() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RS485Connection connect(String target, int mode) {
        if (target == null) {
            return null;
        }
        RS485Connection con = controller.newConnection(2);
        if (con == null) {
            return null;
        }
        RS485Connection rS485Connection = con;
        synchronized (rS485Connection) {
            int chan = con.connNo;
            if (con.state == 1) {
                return null;
            }
            if (RS485.isAddress(target)) {
                con.bind((byte)chan, target, null);
            } else {
                con.bind((byte)chan, null, target);
            }
            con.state = 7;
            try {
                con.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (con.state == 9) {
                con.state = 4;
                con.setIOMode(mode);
                return con;
            }
            con.disconnected();
            controller.freeConnection(con);
        }
        return null;
    }

    public static RS485Connection connect(String target) {
        return RS485.connect(target, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RS485Connection waitForConnection(int timeout, int mode) {
        RS485Connection con;
        if (timeout == 0) {
            timeout = 0x7FFFFFF;
        }
        if ((con = controller.newConnection(1)) == null) {
            return null;
        }
        while (true) {
            RS485Connection rS485Connection = con;
            synchronized (rS485Connection) {
                con.reset();
                con.state = 7;
                do {
                    try {
                        con.wait(timeout < 1000 ? (long)timeout : 1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while ((timeout -= 1000) > 0 && con.state >= 7 && con.state < 9);
                if (con.state == 9) {
                    con.state = 4;
                    con.setIOMode(mode);
                    return con;
                }
                if (con.state > 1) {
                    con.disconnect();
                    controller.freeConnection(con);
                    return null;
                }
            }
        }
    }

    static native int hsSend(byte var0, byte var1, byte[] var2, int var3, int var4, char[] var5);

    static native int hsRecv(byte[] var0, int var1, char[] var2, int var3);

    public static native void hsEnable();

    public static native void hsDisable();

    public static native int hsRead(byte[] var0, int var1, int var2);

    public static native int hsWrite(byte[] var0, int var1, int var2);

    public static NXTCommConnector getConnector() {
        if (connector == null) {
            connector = new Connector();
        }
        return connector;
    }

    static class Connector
    extends NXTCommConnector {
        Connector() {
        }

        public NXTConnection connect(String target, int mode) {
            return RS485.connect(target, mode);
        }

        public NXTConnection waitForConnection(int timeout, int mode) {
            return RS485.waitForConnection(timeout, mode);
        }
    }

    static class Controller
    extends Thread {
        private char[] CRCTable;
        private byte[] frame;
        private int frameLen;
        private final RS485Connection[] connections = new RS485Connection[8];
        private RS485Connection[] slaveConnections = new RS485Connection[8];
        private int devMode = 0;
        private byte[] netAddress = new byte[6];
        private byte[] netName = new byte[16];
        private int connectionCnt = 0;
        private int slaveCnt = 0;
        private int retryCnt = 0;

        Controller() {
            this.frame = new byte[268];
            this.initCRCTable256(4129);
            this.devMode = 0;
            this.connectionCnt = 0;
            this.slaveCnt = 0;
            this.retryCnt = 0;
            this.setDaemon(true);
            this.start();
        }

        private void setAddress() {
            this.netAddress = NXTCommDevice.stringToAddress(NXTCommDevice.getAddress());
            this.netName = NXTCommDevice.stringToName(NXTCommDevice.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setMode(int newMode) {
            RS485Connection[] rS485ConnectionArray = this.connections;
            synchronized (this.connections) {
                if (this.devMode == newMode) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                this.devMode = 0;
                if (newMode == 0) {
                    RS485.hsDisable();
                } else {
                    this.setAddress();
                    RS485.hsEnable();
                    if (newMode == 2) {
                        for (int i = 0; i < 5; ++i) {
                            Delay.msDelay(10L);
                            this.sendControl((byte)0, (byte)83, (byte)0);
                        }
                        Delay.msDelay(250L);
                    }
                    while (this.recvFrame() > 0) {
                        Thread.yield();
                    }
                }
                this.devMode = newMode;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSlaveConnections() {
            RS485Connection[] rS485ConnectionArray = this.connections;
            synchronized (this.connections) {
                int i;
                this.slaveCnt = 0;
                if (this.devMode < 1) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                for (i = 0; i < this.slaveConnections.length; ++i) {
                    this.slaveConnections[i] = null;
                }
                for (i = 0; i < this.connections.length; ++i) {
                    if (this.connections[i] == null) continue;
                    if (this.connections[i].bbAddress == -1) {
                        if (this.slaveConnections[0] != null) continue;
                        this.slaveConnections[0] = this.connections[i];
                        continue;
                    }
                    this.slaveConnections[this.connections[i].bbAddress] = this.connections[i];
                    ++this.slaveCnt;
                }
                if (this.slaveCnt == 0) {
                    this.retryCnt = 0;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectAll() {
            RS485Connection[] rS485ConnectionArray = this.connections;
            synchronized (this.connections) {
                for (int i = 0; i < 8; ++i) {
                    if (this.connections[i] == null) continue;
                    this.connections[i].disconnected();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RS485Connection newConnection(int mode) {
            if (this.devMode != mode && this.devMode != 0) {
                return null;
            }
            RS485Connection[] rS485ConnectionArray = this.connections;
            synchronized (this.connections) {
                int i;
                if (this.connectionCnt == 0) {
                    this.setMode(mode);
                }
                int n = i = mode == 1 ? 0 : 1;
                while (i < this.connections.length) {
                    if (this.connections[i] == null) {
                        this.connections[i] = new RS485Connection(this, i);
                        ++this.connectionCnt;
                        this.updateSlaveConnections();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return this.connections[i];
                    }
                    ++i;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void freeConnection(RS485Connection con) {
            if (con == null) {
                return;
            }
            int i = con.connNo;
            if (i < 0 || i >= this.connections.length) {
                return;
            }
            RS485Connection[] rS485ConnectionArray = this.connections;
            synchronized (this.connections) {
                if (this.connections[i] == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                this.connections[i].connNo = -1;
                this.connections[i] = null;
                this.updateSlaveConnections();
                if (--this.connectionCnt <= 0) {
                    this.setMode(0);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private void initCRCTable256(int crc_poly) {
            this.CRCTable = new char[256];
            for (int val = 0; val < 256; ++val) {
                int result = val << 8;
                for (int i = 0; i < 8; ++i) {
                    if ((result & 0x8000) != 0) {
                        result = result << 1 ^ crc_poly;
                        continue;
                    }
                    result <<= 1;
                }
                this.CRCTable[val] = (char)(result & 0xFFFF);
            }
        }

        private int sendFrame(byte address, byte control, byte[] data, int offset, int len) {
            int cnt;
            while ((cnt = RS485.hsSend(address, control, data, offset, len, this.CRCTable)) == 0) {
                Thread.yield();
            }
            return cnt;
        }

        public int sendData(byte address, byte ack, byte seq, byte[] data, int offset, int len) {
            if (len > 128) {
                len = 128;
            }
            byte control = 16;
            control = (byte)(control | (byte)(ack << 5));
            if (this.sendFrame(address, control = (byte)((byte)(control | (byte)(seq << 1))), data, offset, len) > 0) {
                return len;
            }
            return 0;
        }

        private int sendControl(byte address, byte control, byte ack) {
            return this.sendFrame(address, (byte)(control | ack << 5), null, 0, 0);
        }

        private int recvFrame() {
            int ret;
            int endTime = (int)System.currentTimeMillis() + 10;
            while ((ret = RS485.hsRecv(this.frame, this.frame.length, this.CRCTable, 1)) < 0 && (int)System.currentTimeMillis() < endTime) {
                Thread.yield();
            }
            this.frameLen = ret;
            if (ret > 0) {
                return ret;
            }
            if (ret < 0) {
                return -1;
            }
            endTime = (int)System.currentTimeMillis() + 10;
            while ((ret = RS485.hsRecv(this.frame, this.frame.length, this.CRCTable, 0)) == 0 && (int)System.currentTimeMillis() < endTime) {
                Thread.yield();
            }
            this.frameLen = ret;
            if (ret > 0) {
                return ret;
            }
            return -1;
        }

        int assignAddress(byte addr, byte[] remAddress, byte[] remName) {
            byte[] data = new byte[45];
            int offset = 1;
            data[0] = addr;
            if (remAddress != null && remAddress.length == 6) {
                System.arraycopy(remAddress, 0, data, offset, 6);
            }
            offset += 6;
            if (remName != null && remName.length <= 16) {
                System.arraycopy(remName, 0, data, offset, remName.length);
            }
            System.arraycopy(this.netAddress, 0, data, offset += 16, 6);
            System.arraycopy(this.netName, 0, data, offset += 6, 16);
            return this.sendData((byte)0, (byte)0, (byte)0, data, 0, data.length);
        }

        boolean match(byte[] b1, int off1, byte[] b2, int off2, int len) {
            for (int i = 0; i < len; ++i) {
                if (b1[off1 + i] == b2[off2 + i]) continue;
                return false;
            }
            return true;
        }

        void checkAddress(RS485Connection con) {
            int offset = 3;
            if (this.match(this.frame, offset, this.netAddress, 0, this.netAddress.length) || this.match(this.frame, offset + 6, this.netName, 0, this.netName.length)) {
                byte[] remAddr = new byte[6];
                byte[] remName = new byte[16];
                System.arraycopy(this.frame, offset += 22, remAddr, 0, remAddr.length);
                System.arraycopy(this.frame, offset += 6, remName, 0, remName.length);
                con.bind(this.frame[2], NXTCommDevice.addressToString(remAddr), NXTCommDevice.nameToString(remName));
                con.state = 8;
                this.updateSlaveConnections();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean pollSlave(RS485Connection con) {
            RS485Connection rS485Connection = con;
            synchronized (rS485Connection) {
                int now = (int)System.currentTimeMillis();
                switch (con.state) {
                    case 0: 
                    case 1: {
                        return false;
                    }
                    case 2: {
                        this.sendControl(con.bbAddress, (byte)83, (byte)0);
                        break;
                    }
                    case 7: {
                        this.assignAddress(con.bbAddress, NXTCommDevice.stringToAddress(con.address), NXTCommDevice.stringToName(con.remoteName));
                        this.sendControl(con.bbAddress, (byte)83, (byte)0);
                        break;
                    }
                    case 8: {
                        this.sendControl(con.bbAddress, (byte)-109, (byte)0);
                        break;
                    }
                    default: {
                        if (con.send()) break;
                        if (con.inBuf.length - con.inCnt >= 128) {
                            this.sendControl(con.bbAddress, (byte)17, con.inSeq);
                            break;
                        }
                        this.sendControl(con.bbAddress, (byte)21, con.inSeq);
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processResponse(RS485Connection con) {
            block17: {
                byte addr = this.frame[0];
                byte control = this.frame[1];
                RS485Connection rS485Connection = con;
                synchronized (rS485Connection) {
                    block16: {
                        con.retryCnt = 0;
                        if (addr != con.bbAddress) break block16;
                        if (control == -105) {
                            con.disconnect();
                            return;
                        }
                        switch (con.state) {
                            case 0: 
                            case 1: {
                                break;
                            }
                            case 2: {
                                if (control == 115) {
                                    con.disconnected();
                                    break;
                                }
                                break block17;
                            }
                            case 7: {
                                if (control == 115) {
                                    con.state = 8;
                                    break;
                                }
                                break block17;
                            }
                            case 8: {
                                if (control == 115) {
                                    con.state = 9;
                                    con.notifyAll();
                                    break;
                                }
                                break block17;
                            }
                            default: {
                                if ((control & 0x11) == 16) {
                                    con.recv((byte)(control >>> 1 & 7), this.frame, 2, this.frameLen - 4);
                                    con.ack((byte)(control >>> 5 & 7), false);
                                    break;
                                }
                                if ((control & 0x1B) == 17) {
                                    con.ack((byte)(control >>> 5 & 7), (control & 0x15) == 21);
                                    break;
                                }
                                con.disconnect();
                                break;
                            }
                        }
                        break block17;
                    }
                    if (addr == 0 && control == 83) {
                        this.disconnectAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processRequest() {
            byte addr = this.frame[0];
            byte control = this.frame[1];
            if (addr >= this.slaveConnections.length) {
                return;
            }
            RS485Connection con = this.slaveConnections[addr];
            if (addr == 0) {
                if (control == 83) {
                    this.disconnectAll();
                } else if ((control & 0x11) == 16 && con != null) {
                    RS485Connection rS485Connection = con;
                    synchronized (rS485Connection) {
                        if (con.state == 7) {
                            this.checkAddress(con);
                        }
                    }
                }
                return;
            }
            if (con == null) {
                return;
            }
            RS485Connection rS485Connection = con;
            synchronized (rS485Connection) {
                con.retryCnt = 0;
                if (control == 83) {
                    this.sendControl(addr, (byte)115, (byte)0);
                    if (con.state != 8) {
                        con.disconnected();
                    }
                    return;
                }
                switch (con.state) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.sendControl(addr, (byte)-105, (byte)0);
                        break;
                    }
                    case 8: {
                        if (control != -109) break;
                        con.state = 9;
                        con.notifyAll();
                        this.sendControl(addr, (byte)115, (byte)0);
                        break;
                    }
                    default: {
                        if ((control & 0x11) == 16) {
                            con.recv((byte)(control >>> 1 & 7), this.frame, 2, this.frameLen - 4);
                            con.ack((byte)(control >>> 5 & 7), false);
                        } else if ((control & 0x1B) == 17) {
                            con.ack((byte)(control >>> 5 & 7), (control & 0x15) == 21);
                        } else {
                            con.disconnect();
                        }
                        if (con.state < 3 || con.send()) break;
                        if (con.inBuf.length - con.inCnt >= 128) {
                            this.sendControl(con.bbAddress, (byte)17, con.inSeq);
                            break;
                        }
                        this.sendControl(con.bbAddress, (byte)21, con.inSeq);
                    }
                }
            }
        }

        public void run() {
            while (true) {
                switch (this.devMode) {
                    case 0: {
                        Delay.msDelay(1L);
                        break;
                    }
                    case 2: {
                        for (int i = 1; i < this.connections.length; ++i) {
                            int cnt;
                            RS485Connection con = this.connections[i];
                            if (con == null || !this.pollSlave(con)) continue;
                            for (cnt = 0; cnt < 5 && this.recvFrame() < 0; ++cnt) {
                            }
                            if (cnt >= 5) {
                                if (++con.retryCnt <= 5) continue;
                                con.disconnected();
                                continue;
                            }
                            this.processResponse(con);
                        }
                        break;
                    }
                    case 1: {
                        if (this.recvFrame() >= 0) {
                            this.processRequest();
                            break;
                        }
                        if (this.slaveCnt <= 0 || ++this.retryCnt <= 1000) break;
                        this.disconnectAll();
                    }
                }
                Thread.yield();
            }
        }
    }
}

