/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.RS485;

public class RS485Connection
extends NXTConnection {
    static final int CS_CONNECTING1 = 7;
    static final int CS_CONNECTING2 = 8;
    static final int CS_CONNECTING3 = 9;
    int connNo;
    byte bbAddress;
    String remoteName;
    byte inSeq;
    byte outSeq;
    int sentCnt;
    boolean flowControl = false;
    int retryCnt;
    RS485.Controller controller;

    RS485Connection(RS485.Controller cont, int chan) {
        this.state = 0;
        this.controller = cont;
        this.connNo = chan;
        this.is = null;
        this.os = null;
        this.bbAddress = (byte)-1;
        this.bufSz = 128;
    }

    public String getName() {
        return this.remoteName;
    }

    synchronized void reset() {
        this.state = 0;
        this.inBuf = null;
        this.outBuf = null;
        this.bbAddress = (byte)-1;
        this.notifyAll();
    }

    synchronized void bind(byte bbAddr, String remAddress, String remName) {
        if (this.inBuf == null) {
            this.inBuf = new byte[256];
        }
        if (this.outBuf == null) {
            this.outBuf = new byte[128];
        }
        this.setIOMode(0);
        this.inCnt = 0;
        this.inOffset = 0;
        this.outCnt = 0;
        this.outOffset = 0;
        this.sentCnt = 0;
        this.pktLen = 0;
        this.inSeq = 0;
        this.outSeq = 0;
        this.bbAddress = bbAddr;
        this.address = remAddress;
        this.remoteName = remName;
        this.flowControl = false;
        this.retryCnt = 0;
    }

    synchronized void sendEOF() {
    }

    synchronized void disconnect() {
        if (this.state > 2) {
            this.state = 2;
        }
    }

    synchronized boolean send() {
        if (this.outOffset >= this.outCnt || this.flowControl) {
            return false;
        }
        this.sentCnt = this.controller.sendData(this.bbAddress, this.inSeq, this.outSeq, this.outBuf, this.outOffset, this.outCnt - this.outOffset);
        return this.sentCnt > 0;
    }

    synchronized void ack(byte seq, boolean flow) {
        this.flowControl = flow;
        if (seq == (this.outSeq + 1 & 7)) {
            this.outOffset += this.sentCnt;
            this.sentCnt = 0;
            if (this.outOffset >= this.outCnt) {
                this.outOffset = 0;
                this.outCnt = 0;
                this.notifyAll();
            }
            this.outSeq = seq;
        } else if (seq != this.outSeq) {
            this.disconnect();
        }
    }

    synchronized int flushBuffer(boolean wait) {
        if (this.outOffset >= this.outCnt) {
            return 1;
        }
        if (wait) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.outCnt - this.outOffset;
    }

    synchronized void recv(byte seq, byte[] data, int dataOffset, int dataLen) {
        if (seq == this.inSeq) {
            if (dataLen <= this.inBuf.length - this.inCnt) {
                while (dataLen > 0) {
                    int offset;
                    int len;
                    if (this.inCnt == 0) {
                        this.inOffset = 0;
                    }
                    int n = len = (offset = (this.inOffset + this.inCnt) % this.inBuf.length) >= this.inOffset ? this.inBuf.length - offset : this.inOffset - offset;
                    if (len > dataLen) {
                        len = dataLen;
                    }
                    System.arraycopy(data, dataOffset, this.inBuf, offset, len);
                    this.inCnt += len;
                    dataOffset += len;
                    dataLen -= len;
                }
                this.inSeq = (byte)(this.inSeq + 1 & 7);
            }
        } else if (seq != (this.inSeq - 1 & 7)) {
            this.disconnect();
        }
        if (this.inCnt > 0) {
            this.notifyAll();
        }
    }

    synchronized int fillBuffer(boolean wait) {
        if (this.inCnt > 0) {
            return this.inCnt;
        }
        if (wait) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.inCnt;
    }

    void freeConnection() {
        if (this.state < 7) {
            this.controller.freeConnection(this);
        }
    }
}

