/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.localization;

import lejos.nxt.Motor;
import lejos.robotics.Movement;
import lejos.robotics.Pose;
import lejos.robotics.RangeReadings;
import lejos.robotics.localization.MCLParticleSet;
import lejos.robotics.mapping.RangeMap;
import lejos.robotics.navigation.SimpleNavigator;

public abstract class TachoLocalizer
extends SimpleNavigator {
    protected RangeReadings readings;
    protected float projection;
    protected RangeMap map;
    protected int numParticles;
    protected MCLParticleSet particles;
    protected float angle;
    protected float distance;
    protected Movement mv;
    protected int numReadings;
    protected boolean isMoving;

    public TachoLocalizer(RangeMap map, int numParticles, int numReadings, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, float projection, boolean reverse) {
        super(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
        this.projection = projection;
        this.numParticles = numParticles;
        this.map = map;
        this.particles = new MCLParticleSet(map, numParticles, 0);
        this.numReadings = numReadings;
        this.readings = new RangeReadings(numReadings);
    }

    public abstract void takeReadings();

    public void rotate(float angle, boolean immediateReturn) {
        this.angle = angle;
        super.rotate(angle, immediateReturn);
    }

    public void travel(float distance, boolean immediateReturn) {
        this.distance = distance;
        super.travel(distance, immediateReturn);
    }

    public void updatePosition() {
        super.updatePosition();
        if (this.angle != 0.0f || this.distance != 0.0f) {
            this.mv = new Movement(Movement.MovementType.TRAVEL, this.angle, this.distance, this.isMoving);
            this.particles.applyMove(this.mv);
        }
        this.angle = 0.0f;
        this.distance = 0.0f;
    }

    public float getProjection() {
        return this.projection;
    }

    public int numParticles() {
        return this.numParticles;
    }

    public MCLParticleSet getParticles() {
        return this.particles;
    }

    public RangeMap getMap() {
        return this.map;
    }

    public Pose getEstimatedPose() {
        return this.particles.getEstimatedPose();
    }

    public RangeReadings getReadings() {
        return this.readings;
    }
}

