///////////////////////////////////////////////////////////
//  LineTraceRightDTech.cpp
//  Implementation of the Class LineTraceRightDTech
//  Created on:      11-7-2009 20:33:33
//  Original author: Administrator
///////////////////////////////////////////////////////////

#include "LineTraceRightDTech.h"


LineTraceRightDTech::LineTraceRightDTech(const ecrobot::Nxt& nxt,
		const ecrobot::GyroSensor& gyro, ecrobot::Motor& leftMotor,
		ecrobot::Motor& rightMotor, LightSensorValue& bb,
		ControlAlgorithm& algorithm) :
			IDTech(nxt, gyro, leftMotor, rightMotor, bb), 
			m_Algorithm(algorithm) {
}


LineTraceRightDTech::~LineTraceRightDTech(){
}

void LineTraceRightDTech::init() {
	m_Algorithm.init();
	m_Algorithm.rightEdge();
//	m_Algorithm.backward();
	m_Algorithm.forward();
}

void LineTraceRightDTech::drive() {
	// ZT[l𓾂
	m_Light = m_BlackBoard.inspect();
	
	// lƑxl𓾂
	m_Algorithm.getCommand(m_Light, m_Direction, m_Velocity);

	// oXs
	balance();
}
