/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Character
implements Comparable<Character> {
    public static final int SIZE = 16;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_CODE_POINT = 0;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final Class<?> TYPE = null;
    private final char value;

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.charValue();
    }

    @Override
    public int compareTo(Character ob) {
        if (this.value == ob.value) {
            return 0;
        }
        return this.value > ob.value ? 1 : -1;
    }

    public int codePointAt(char[] c, int index) {
        return this.codePointAt(c, index, c.length);
    }

    public int codePointAt(char[] c, int index, int limit) {
        char c2;
        int index2;
        char c1 = c[index];
        if (Character.isHighSurrogate(c1) && (index2 = index + 1) < limit && Character.isLowSurrogate(c2 = c[index2])) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public int codePointAt(CharSequence c, int index) {
        char c2;
        int index2;
        char c1 = c.charAt(index);
        if (Character.isHighSurrogate(c1) && (index2 = index + 1) < c.length() && Character.isLowSurrogate(c2 = c.charAt(index2))) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public int codePointBefore(char[] c, int index) {
        return this.codePointBefore(c, index, 0);
    }

    public int codePointBefore(char[] c, int index, int start) {
        char c1;
        int index2;
        char c2 = c[index - 1];
        if (Character.isLowSurrogate(c2) && (index2 = index - 2) >= start && Character.isHighSurrogate(c1 = c[index2])) {
            return Character.toCodePoint(c1, c2);
        }
        return c2;
    }

    public int codePointBefore(CharSequence c, int index) {
        char c1;
        int index2;
        char c2 = c.charAt(index - 1);
        if (Character.isLowSurrogate(c2) && (index2 = index - 2) >= 0 && Character.isHighSurrogate(c1 = c.charAt(index2))) {
            return Character.toCodePoint(c1, c2);
        }
        return c2;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' & ch <= '9';
    }

    public static boolean isLowSurrogate(char low) {
        return low >= '\udc00' && low <= '\udfff';
    }

    public static boolean isHighSurrogate(char high) {
        return high >= '\ud800' && high <= '\udbff';
    }

    public static boolean isSurrogatePair(char high, char low) {
        return high >= '\ud800' && high <= '\udbff' && low >= '\udc00' && low <= '\udfff';
    }

    public static boolean isValidCodePoint(int codepoint) {
        return codepoint >= 0 && codepoint <= 0x10FFFF;
    }

    public static boolean isSupplementaryCodePoint(int codepoint) {
        return codepoint >= 65536 && codepoint <= 0x10FFFF;
    }

    public static int charCount(int codepoint) {
        return codepoint < 65536 ? 1 : 2;
    }

    public static char[] toChars(int codepoint) {
        if (codepoint < 0 || codepoint > 0x10FFFF) {
            throw new IllegalArgumentException("invalid codepoint");
        }
        if (codepoint < 65536) {
            return new char[]{(char)codepoint};
        }
        return new char[]{(char)((codepoint -= 65536) >> 10 | 0xD800), (char)(codepoint & 0x3FF | 0xDC00)};
    }

    public static int toChars(int codepoint, char[] dst, int off) {
        if (codepoint < 0 || codepoint > 0x10FFFF) {
            throw new IllegalArgumentException("invalid codepoint");
        }
        if (codepoint < 65536) {
            dst[off] = (char)codepoint;
            return 1;
        }
        dst[off] = (char)((codepoint -= 65536) >> 10 | 0xD800);
        dst[off + 1] = (char)(codepoint & 0x3FF | 0xDC00);
        return 2;
    }

    public static int toCodePoint(char high, char low) {
        return high << 10 + low - 0x3600000 - 56320 + 65536;
    }

    public static int digit(char ch, int radix) {
        return Character.digit((int)ch, radix);
    }

    public static int digit(int ch, int radix) {
        if (radix < 2 || radix > 36) {
            return -1;
        }
        if (ch >= 48 && ch <= 57) {
            ch -= 48;
        } else if (ch >= 97 && ch <= 122) {
            ch -= 87;
        } else if (ch >= 65 && ch <= 90) {
            ch -= 55;
        } else {
            return -1;
        }
        if (ch >= radix) {
            return -1;
        }
        return ch;
    }

    public boolean equals(Object o) {
        return o instanceof Character && this.value == ((Character)o).value;
    }

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36) {
            return '\u0000';
        }
        if (digit < 0 || digit >= radix) {
            return '\u0000';
        }
        char r = digit < 10 ? (char)(digit + 48) : (char)(digit + 87);
        return r;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Character.toString(this.value);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static Character valueOf(char c) {
        return new Character(c);
    }

    public static char reverseBytes(char c) {
        return (char)(c << 8 | c >> 8);
    }
}

