/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_VALUE = -2147483648;
    public static final int SIZE = 32;
    public static final Class<?> TYPE = null;
    private final int value;
    @Deprecated
    public static final int MIN_RADIX = 2;
    @Deprecated
    public static final int MAX_RADIX = 36;

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s);
    }

    public int bitCount(int v) {
        v -= v >>> 1 & 0x55555555;
        v = (v & 0x33333333) + (v >>> 2 & 0x33333333);
        v = v + (v >>> 4) & 0xF0F0F0F;
        v += v >>> 16;
        v += v >>> 8;
        return v & 0xFF;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Integer ob) {
        if (this.value == ob.value) {
            return 0;
        }
        return this.value > ob.value ? 1 : -1;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Integer && this.value == ((Integer)o).value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static int highestOneBit(int v) {
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        return v - (v >>> 1);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static int lowestOneBit(int v) {
        return v & -v;
    }

    public static int numberOfLeadingZeros(int v) {
        if (v == 0) {
            return 32;
        }
        int c = 1;
        if ((v & 0xFFFF0000) == 0) {
            c += 16;
            v <<= 16;
        }
        if ((v & 0xFF000000) == 0) {
            c += 8;
            v <<= 8;
        }
        if ((v & 0xF0000000) == 0) {
            c += 4;
            v <<= 4;
        }
        if ((v & 0x30000000) == 0) {
            c += 2;
            v <<= 2;
        }
        return c - (v >>> 31);
    }

    public static int numberOfTrailingZeros(int v) {
        if (v == 0) {
            return 32;
        }
        int c = 1;
        if ((v & 0xFFFF) == 0) {
            c += 16;
            v >>>= 16;
        }
        if ((v & 0xFF) == 0) {
            c += 8;
            v >>>= 8;
        }
        if ((v & 0xF) == 0) {
            c += 4;
            v >>>= 4;
        }
        if ((v & 3) == 0) {
            c += 2;
            v >>>= 2;
        }
        return c - (v & 1);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10);
    }

    public static int parseInt(String s, int radix) {
        boolean negative;
        int limit;
        int p;
        StringUtils.throwNumberFormat(s, radix);
        int len = s.length();
        if (len > 0 && s.charAt(0) == '-') {
            p = 1;
            limit = Integer.MIN_VALUE;
            negative = true;
        } else {
            p = 0;
            limit = -2147483647;
            negative = false;
        }
        if (len <= p) {
            throw new NumberFormatException("string doesn't contain any digits");
        }
        int multlimit = limit / radix;
        int r = 0;
        while (p < len) {
            int digit = StringUtils.parseDigit(s.charAt(p++), radix);
            if (r < multlimit) {
                throw new NumberFormatException("number is too big");
            }
            if ((r *= radix) < limit + digit) {
                throw new NumberFormatException("number is too big");
            }
            r -= digit;
        }
        return negative ? r : -r;
    }

    public static int reverse(int v) {
        v = (v & 0x55555555) << 1 | v >>> 1 & 0x55555555;
        v = (v & 0x33333333) << 2 | v >>> 2 & 0x33333333;
        v = (v & 0xF0F0F0F) << 4 | v >>> 4 & 0xF0F0F0F;
        return Integer.reverseBytes(v);
    }

    public static int reverseBytes(int v) {
        v = (v & 0xFF00FF) << 8 | v >>> 8 & 0xFF00FF;
        return v << 16 | v >>> 16;
    }

    public static int rotateLeft(int v, int bits) {
        return v << bits | v >>> -bits;
    }

    public static int rotateRight(int v, int bits) {
        return v >>> bits | v << -bits;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public static int signnum(long i) {
        return (int)(i >> 31) | (int)(-i >>> 31);
    }

    public static String toBinaryString(int v) {
        return Integer.toUnsignedString(v, 32, 1, 1);
    }

    public static String toHexString(int v) {
        return Integer.toUnsignedString(v, 8, 15, 4);
    }

    public static String toOctalString(int v) {
        return Integer.toUnsignedString(v, 11, 7, 3);
    }

    private static String toUnsignedString(int v, int maxlen, int mask, int shift) {
        char[] buf = new char[maxlen];
        int p = maxlen;
        do {
            buf[--p] = Character.forDigit(mask & v, 16);
        } while ((v >>>= shift) != 0);
        return new String(buf, p, maxlen - p);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int v) {
        return String.valueOf(v, 10);
    }

    public static String toString(int v, int radix) {
        radix = StringUtils.invalidRadixTo10(radix);
        return String.valueOf(v, radix);
    }

    public static Integer valueOf(int v) {
        return new Integer(v);
    }

    public static Integer valueOf(String s) {
        return Integer.valueOf(s, 10);
    }

    public static Integer valueOf(String s, int radix) {
        return Integer.parseInt(s, radix);
    }

    @Deprecated
    public static int digit(char ch, int radix) {
        return Character.digit((int)ch, radix);
    }

    @Deprecated
    public static int digit(int ch, int radix) {
        return Character.digit(ch, radix);
    }
}

