/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Long
extends Number
implements Comparable<Long> {
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final int SIZE = 64;
    public static final Class<?> TYPE = null;
    private final long value;

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) {
        this.value = Long.parseLong(s);
    }

    public int bitCount(long v) {
        v -= v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        v = v + (v >>> 4) & 0xF0F0F0F0F0F0F0FL;
        int i = (int)v + (int)(v >>> 32);
        i += i >>> 16;
        i += i >>> 8;
        return i & 0xFF;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Long ob) {
        if (this.value == ob.value) {
            return 0;
        }
        return this.value > ob.value ? 1 : -1;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Long && this.value == ((Long)o).value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public static long highestOneBit(long v) {
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        v |= v >>> 32;
        return v - (v >>> 1);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static long lowestOneBit(long v) {
        return v & -v;
    }

    public static int numberOfLeadingZeros(long v) {
        int c = 1;
        int i = (int)(v >>> 32);
        if (i == 0) {
            i = (int)v;
            if (i == 0) {
                return 64;
            }
            c += 32;
        }
        if ((i & 0xFFFF0000) == 0) {
            c += 16;
            i <<= 16;
        }
        if ((i & 0xFF000000) == 0) {
            c += 8;
            i <<= 8;
        }
        if ((i & 0xF0000000) == 0) {
            c += 4;
            i <<= 4;
        }
        if ((i & 0x30000000) == 0) {
            c += 2;
            i <<= 2;
        }
        return c - (i >>> 31);
    }

    public static int numberOfTrailingZeros(long v) {
        int c = 1;
        int i = (int)v;
        if (i == 0) {
            i = (int)(v >>> 32);
            if (i == 0) {
                return 64;
            }
            c += 32;
        }
        if ((i & 0xFFFF) == 0) {
            c += 16;
            i >>>= 16;
        }
        if ((i & 0xFF) == 0) {
            c += 8;
            i >>>= 8;
        }
        if ((i & 0xF) == 0) {
            c += 4;
            i >>>= 4;
        }
        if ((i & 3) == 0) {
            c += 2;
            i >>>= 2;
        }
        return c - (i & 1);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s, 10);
    }

    public static long parseLong(String s, int radix) {
        boolean negative;
        long limit;
        int p;
        StringUtils.throwNumberFormat(s, radix);
        int len = s.length();
        if (len > 0 && s.charAt(0) == '-') {
            p = 1;
            limit = Long.MIN_VALUE;
            negative = true;
        } else {
            p = 0;
            limit = -9223372036854775807L;
            negative = false;
        }
        if (len <= p) {
            throw new NumberFormatException("string doesn't contain any digits");
        }
        long multlimit = limit / (long)radix;
        long r = 0L;
        while (p < len) {
            int digit = StringUtils.parseDigit(s.charAt(p++), radix);
            if (r < multlimit) {
                throw new NumberFormatException("number is too big");
            }
            if ((r *= (long)radix) < limit + (long)digit) {
                throw new NumberFormatException("number is too big");
            }
            r -= (long)digit;
        }
        return negative ? r : -r;
    }

    public static long reverse(long v) {
        v = (v & 0x5555555555555555L) << 1 | v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) << 2 | v >>> 2 & 0x3333333333333333L;
        v = (v & 0xF0F0F0F0F0F0F0FL) << 4 | v >>> 4 & 0xF0F0F0F0F0F0F0FL;
        return Long.reverseBytes(v);
    }

    public static long reverseBytes(long v) {
        v = (v & 0xFF00FF00FF00FFL) << 8 | v >>> 8 & 0xFF00FF00FF00FFL;
        v = (v & 0xFFFF0000FFFFL) << 16 | v >>> 16 & 0xFFFF0000FFFFL;
        return v << 32 | v >>> 32;
    }

    public static long rotateLeft(long v, int bits) {
        return v << bits | v >>> -bits;
    }

    public static long rotateRight(long v, int bits) {
        return v >>> bits | v << -bits;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public static int signnum(long i) {
        return (int)(i >> 63) | (int)(-i >>> 63);
    }

    public static String toBinaryString(long v) {
        return Long.toUnsignedString(v, 64, 1, 1);
    }

    public static String toOctalString(long v) {
        return Long.toUnsignedString(v, 22, 7, 3);
    }

    public static String toHexString(long v) {
        return Long.toUnsignedString(v, 16, 15, 4);
    }

    private static String toUnsignedString(long v, int maxlen, int mask, int shift) {
        char[] buf = new char[maxlen];
        int p = maxlen;
        do {
            buf[--p] = Character.forDigit(mask & (int)v, 16);
        } while ((v >>>= shift) != 0L);
        return new String(buf, p, maxlen - p);
    }

    public String toString() {
        return String.valueOf(this.value, 10);
    }

    public static String toString(long v) {
        return String.valueOf(v, 10);
    }

    public static String toString(long v, int radix) {
        radix = StringUtils.invalidRadixTo10(radix);
        return String.valueOf(v, radix);
    }

    public static Long valueOf(long v) {
        return new Long(v);
    }

    public static Long valueOf(String s) {
        return Long.valueOf(s, 10);
    }

    public static Long valueOf(String s, int radix) {
        return Long.parseLong(s, radix);
    }
}

