/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    static final double LN2 = 0.6931471805599453;
    static final double LN10 = 2.302585092994046;
    private static final double SQRT2 = 1.4142135623730951;
    private static final double LN_SQRT2 = 0.34657359027997264;
    private static final double INV_LN2 = 1.4426950408889634;
    private static final double INV_SQRT2 = 0.7071067811865476;
    private static final double PIhalf = 1.5707963267948966;
    private static final double PIhalfhalf = 0.7853981633974483;
    private static final double PItwice = 6.283185307179586;
    private static final double SQRT2half = 0.7071067811865476;
    private static final double DEG_TO_RAD = 0.017453292519943295;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final float ROUND_FLOAT_MAX = 1.0737418E9f;
    private static final float ROUND_FLOAT_MIN = -1.0737418E9f;
    private static final double ROUND_DOUBLE_MAX = 4.611686018427388E18;
    private static final double ROUND_DOUBLE_MIN = -4.611686018427388E18;
    private static Random RAND = new Random(System.currentTimeMillis());
    private static final double COEFF_EXP_00 = 1.0;
    private static final double COEFF_EXP_01 = 1.0000000000000013;
    private static final double COEFF_EXP_02 = 0.49999999999990424;
    private static final double COEFF_EXP_03 = 0.16666666666933783;
    private static final double COEFF_EXP_04 = 0.041666666628388985;
    private static final double COEFF_EXP_05 = 0.00833333365529437;
    private static final double COEFF_EXP_06 = 0.001388887180508439;
    private static final double COEFF_EXP_07 = 1.9841863599405984E-4;
    private static final double COEFF_EXP_08 = 2.4787899939827274E-5;
    private static final double COEFF_EXP_09 = 2.7764095742841978E-6;
    private static final double COEFF_EXP_10 = 2.560248550622929E-7;
    private static final double COEFF_EXP_11 = 3.534728345620992E-8;
    private static double COEFF_LOG_01 = 2.0;
    private static double COEFF_LOG_03 = 0.6666666666666666;
    private static double COEFF_LOG_05 = 0.4;
    private static double COEFF_LOG_07 = 0.2857142857142857;
    private static double COEFF_LOG_09 = 0.2222222222222222;
    private static double COEFF_LOG_11 = 0.18181818181818182;
    private static double COEFF_LOG_13 = 0.15384615384615385;
    private static double COEFF_LOG_15 = 0.13333333333333333;
    private static double COEFF_LOG_17 = 0.11764705882352941;
    private static double COEFF_LOG_19 = 0.10526315789473684;
    private static final double COEFF_SIN_01 = 1.0;
    private static final double COEFF_SIN_03 = -0.16666666666666524;
    private static final double COEFF_SIN_05 = 0.008333333333308338;
    private static final double COEFF_SIN_07 = -1.984126982196707E-4;
    private static final double COEFF_SIN_09 = 2.7557311570774412E-6;
    private static final double COEFF_SIN_11 = -2.5050482812758418E-8;
    private static final double COEFF_SIN_13 = 1.5883056913369978E-10;
    private static final double COEFF_COS_00 = 1.0;
    private static final double COEFF_COS_02 = -0.5;
    private static final double COEFF_COS_04 = 0.04166666666666645;
    private static final double COEFF_COS_06 = -0.0013888888888861101;
    private static final double COEFF_COS_08 = 2.480158728388399E-5;
    private static final double COEFF_COS_10 = -2.7557313098464816E-7;
    private static final double COEFF_COS_12 = 2.0875582460212687E-9;
    private static final double COEFF_COS_14 = -1.1353383322749354E-11;
    private static final double COEFF_TAN_A01 = 1.1632084063591752;
    private static final double COEFF_TAN_A03 = -0.1551562294271972;
    private static final double COEFF_TAN_A05 = 0.003984273522258578;
    private static final double COEFF_TAN_A07 = -2.0783852816388208E-5;
    private static final double COEFF_TAN_B00 = 1.1632084063591752;
    private static final double COEFF_TAN_B02 = -0.5428923648802556;
    private static final double COEFF_TAN_B04 = 0.02985394096778726;
    private static final double COEFF_TAN_B06 = -3.627755504463479E-4;
    private static final double COEFF_TAN_B08 = 5.798383713759289E-7;
    private static final double COEFF_ARCTAN_A01 = 0.21480982386448075;
    private static final double COEFF_ARCTAN_A03 = 0.5822336291803317;
    private static final double COEFF_ARCTAN_A05 = 0.5896935461740918;
    private static final double COEFF_ARCTAN_A07 = 0.2762961405471209;
    private static final double COEFF_ARCTAN_A09 = 0.05998846249230414;
    private static final double COEFF_ARCTAN_A11 = 0.005241080670594091;
    private static final double COEFF_ARCTAN_A13 = 1.2030822093367211E-4;
    private static final double COEFF_ARCTAN_B00 = 0.21480982386448075;
    private static final double COEFF_ARCTAN_B02 = 0.6538369038018249;
    private static final double COEFF_ARCTAN_B04 = 0.7646772160018243;
    private static final double COEFF_ARCTAN_B06 = 0.4311082828151354;
    private static final double COEFF_ARCTAN_B08 = 0.12029329400162579;
    private static final double COEFF_ARCTAN_B10 = 0.01523641193862142;
    private static final double COEFF_ARCTAN_B12 = 6.791021403500245E-4;
    private static final double COEFF_ARCTAN_B14 = 4.538215780227675E-6;

    private Math() {
    }

    public static double abs(double a) {
        return a <= 0.0 ? 0.0 - a : a;
    }

    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static float signum(float f) {
        if (f == 0.0f) {
            return f;
        }
        if (f > 0.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return -1.0f;
        }
        return Float.NaN;
    }

    public static double signum(double d) {
        if (d == 0.0) {
            return d;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return Double.NaN;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static long min(long a, long b) {
        return a < b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static long max(long a, long b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static double floor(double a) {
        if (a < -4.611686018427388E18 || a > 4.611686018427388E18) {
            return a;
        }
        long b = (long)a;
        double bd = b;
        if (b >= 0L) {
            return bd;
        }
        if (bd == a) {
            return bd;
        }
        return bd - 1.0;
    }

    public static double ceil(double a) {
        if (a < -4.611686018427388E18 || a > 4.611686018427388E18) {
            return a;
        }
        long b = (long)a;
        double bd = b;
        if (b <= 0L) {
            return bd;
        }
        if (bd == a) {
            return bd;
        }
        return bd + 1.0;
    }

    public static int round(float a) {
        if (a < -1.0737418E9f || a > 1.0737418E9f) {
            return (int)a;
        }
        return (int)Math.floor((double)a + 0.5);
    }

    public static long round(double a) {
        return (long)Math.floor(a + 0.5);
    }

    public static double rint(double a) {
        if (a < -4.611686018427388E18 || a > 4.611686018427388E18) {
            return a;
        }
        if (a < 0.0) {
            return (long)(a - 0.5);
        }
        return (long)(a + 0.5);
    }

    public static synchronized double random() {
        int n = Integer.MAX_VALUE;
        while (n == Integer.MAX_VALUE) {
            n = Math.abs(RAND.nextInt());
        }
        return (double)n * 4.656612875245797E-10;
    }

    public static double sqrt(double x) {
        double factor;
        if (!(x > 0.0)) {
            return x == 0.0 ? x : Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return x;
        }
        if (x >= Double.MIN_NORMAL) {
            factor = 0.5;
        } else {
            x *= 1.8446744073709552E19;
            factor = 1.1641532182693481E-10;
        }
        double isqrt = Double.longBitsToDouble(6910470738111508698L - (Double.doubleToRawLongBits(x) >> 1));
        double xhalf = 0.5 * x;
        isqrt *= 1.5 - xhalf * isqrt * isqrt;
        isqrt *= 1.5 - xhalf * isqrt * isqrt;
        isqrt *= 1.5 - xhalf * isqrt * isqrt;
        return factor * (x * isqrt + 1.0 / isqrt);
    }

    public static double exp(double x) {
        if (!(x > -750.0)) {
            return x < 0.0 ? 0.0 : Double.NaN;
        }
        if (x > 710.0) {
            return Double.POSITIVE_INFINITY;
        }
        int k = (int)(x * 1.4426950408889634);
        if (x < 0.0) {
            --k;
        }
        double f1 = 1.0 + (1.0000000000000013 + (0.49999999999990424 + (0.16666666666933783 + (0.041666666628388985 + (0.00833333365529437 + (0.001388887180508439 + (1.9841863599405984E-4 + (2.4787899939827274E-5 + (2.7764095742841978E-6 + (2.560248550622929E-7 + 3.534728345620992E-8 * (x -= (double)k * 0.6931471805599453)) * x) * x) * x) * x) * x) * x) * x) * x) * x) * x;
        if (k > 1000) {
            k -= 1000;
            f1 *= 1.0715086071862673E301;
        } else if (k < -1000) {
            k += 1000;
            f1 *= 9.332636185032189E-302;
        }
        double f2 = Double.longBitsToDouble((long)(k + 1023) << 52);
        return f1 * f2;
    }

    public static double log(double x) {
        int m;
        if (!(x > 0.0)) {
            return x == 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x >= Double.MIN_NORMAL) {
            m = -1023;
        } else {
            m = -1087;
            x *= 1.8446744073709552E19;
        }
        long bits = Double.doubleToRawLongBits(x);
        m = m + (int)(bits >>> 52) << 1;
        bits = bits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L;
        x = Double.longBitsToDouble(bits);
        if (x > 1.4142135623730951) {
            ++m;
            x *= 0.7071067811865476;
        }
        double zeta = (x - 1.0) / (x + 1.0);
        double zeta2 = zeta * zeta;
        double r = (COEFF_LOG_01 + (COEFF_LOG_03 + (COEFF_LOG_05 + (COEFF_LOG_07 + (COEFF_LOG_09 + (COEFF_LOG_11 + (COEFF_LOG_13 + (COEFF_LOG_15 + (COEFF_LOG_17 + COEFF_LOG_19 * zeta2) * zeta2) * zeta2) * zeta2) * zeta2) * zeta2) * zeta2) * zeta2) * zeta2) * zeta;
        return (double)m * 0.34657359027997264 + r;
    }

    public static double pow(double a, double b) {
        return Math.exp(b * Math.log(a));
    }

    public static double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    public static double toRadians(double angdeg) {
        return angdeg * (Math.PI / 180);
    }

    private static double sin_chebypade(double x) {
        double x2 = x * x;
        return (1.0 + (-0.16666666666666524 + (0.008333333333308338 + (-1.984126982196707E-4 + (2.7557311570774412E-6 + (-2.5050482812758418E-8 + 1.5883056913369978E-10 * x2) * x2) * x2) * x2) * x2) * x2) * x;
    }

    private static double cos_chebypade(double x) {
        double x2 = x * x;
        return 1.0 + (-0.5 + (0.04166666666666645 + (-0.0013888888888861101 + (2.480158728388399E-5 + (-2.7557313098464816E-7 + (2.0875582460212687E-9 + -1.1353383322749354E-11 * x2) * x2) * x2) * x2) * x2) * x2) * x2;
    }

    public static double sin(double x) {
        int neg = 0;
        if ((x %= Math.PI * 2) < 0.0) {
            ++neg;
            x = -x;
        }
        if (x > Math.PI) {
            ++neg;
            x -= Math.PI;
        }
        if (x > 1.5707963267948966) {
            x = Math.PI - x;
        }
        double y = x < 0.7853981633974483 ? Math.sin_chebypade(x) : Math.cos_chebypade(1.5707963267948966 - x);
        return (neg & 1) == 0 ? y : -y;
    }

    public static double cos(double x) {
        int neg = 0;
        if ((x %= Math.PI * 2) < 0.0) {
            x = -x;
        }
        if (x > Math.PI) {
            ++neg;
            x -= Math.PI;
        }
        if (x > 1.5707963267948966) {
            ++neg;
            x = Math.PI - x;
        }
        double y = x < 0.7853981633974483 ? Math.cos_chebypade(x) : Math.sin_chebypade(1.5707963267948966 - x);
        return (neg & 1) == 0 ? y : -y;
    }

    public static double tan(double x) {
        boolean inv;
        int neg = 0;
        if ((x %= Math.PI) < 0.0) {
            ++neg;
            x = -x;
        }
        if (x > 1.5707963267948966) {
            ++neg;
            x = Math.PI - x;
        }
        boolean bl = inv = x > 0.7853981633974483;
        if (inv) {
            x = 1.5707963267948966 - x;
        }
        double x2 = x * x;
        double a = (1.1632084063591752 + (-0.1551562294271972 + (0.003984273522258578 + -2.0783852816388208E-5 * x2) * x2) * x2) * x;
        double b = 1.1632084063591752 + (-0.5428923648802556 + (0.02985394096778726 + (-3.627755504463479E-4 + 5.798383713759289E-7 * x2) * x2) * x2) * x2;
        double y = inv ? b / a : a / b;
        return (neg & 1) == 0 ? y : -y;
    }

    private static double arctan_chebypade(double x) {
        double x2 = x * x;
        return (0.21480982386448075 + (0.5822336291803317 + (0.5896935461740918 + (0.2762961405471209 + (0.05998846249230414 + (0.005241080670594091 + 1.2030822093367211E-4 * x2) * x2) * x2) * x2) * x2) * x2) * x / (0.21480982386448075 + (0.6538369038018249 + (0.7646772160018243 + (0.4311082828151354 + (0.12029329400162579 + (0.01523641193862142 + (6.791021403500245E-4 + 4.538215780227675E-6 * x2) * x2) * x2) * x2) * x2) * x2) * x2);
    }

    public static double atan(double x) {
        boolean inv;
        boolean neg;
        boolean bl = neg = x < 0.0;
        if (neg) {
            x = -x;
        }
        boolean bl2 = inv = x > 1.0;
        if (inv) {
            x = 1.0 / x;
        }
        double y = Math.arctan_chebypade(x);
        if (inv) {
            y = 1.5707963267948966 - y;
        }
        return neg ? -y : y;
    }

    public static double atan2(double y, double x) {
        double r;
        boolean inv;
        boolean neg_x;
        boolean neg_y;
        boolean bl = neg_y = y < 0.0;
        if (neg_y) {
            y = -y;
        }
        boolean bl2 = neg_x = x < 0.0;
        if (neg_x) {
            x = -x;
        }
        if (x == y) {
            inv = false;
            r = x == 0.0 ? 0.0 : 0.7853981633974483;
        } else {
            inv = y > x;
            r = Math.arctan_chebypade(inv ? x / y : y / x);
        }
        if (inv) {
            r = neg_x ? (r += 1.5707963267948966) : 1.5707963267948966 - r;
        } else if (neg_x) {
            r = Math.PI - r;
        }
        return neg_y ? -r : r;
    }

    public static double asin(double a) {
        boolean neg;
        boolean bl = neg = a < 0.0;
        if (neg) {
            a = -a;
        }
        if (!(a <= 1.0)) {
            return Double.NaN;
        }
        double b = Math.sqrt(1.0 - a * a);
        boolean norm = a < 0.7071067811865476;
        double y = Math.arctan_chebypade(norm ? a / b : b / a);
        if (!norm) {
            y = 1.5707963267948966 - y;
        }
        return neg ? -y : y;
    }

    public static double acos(double a) {
        boolean neg;
        boolean bl = neg = a < 0.0;
        if (neg) {
            a = -a;
        }
        if (!(a <= 1.0)) {
            return Double.NaN;
        }
        double b = Math.sqrt(1.0 - a * a);
        boolean norm = a < 0.7071067811865476;
        double y = Math.arctan_chebypade(norm ? a / b : b / a);
        if (norm) {
            y = neg ? (y += 1.5707963267948966) : 1.5707963267948966 - y;
        } else if (neg) {
            y = Math.PI - y;
        }
        return y;
    }
}

