/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.OutputStream;
import lejos.nxt.comm.NXTConnection;

class NXTSocketOutputStream
extends OutputStream {
    private byte[] buffer;
    private int numBytes = 0;
    private NXTConnection conn = null;
    private static final byte ESCAPE = -1;
    private static final byte ESCAPE_ESCAPE = 0;
    private static final byte ESCAPE_CLOSE = 1;

    NXTSocketOutputStream(NXTConnection conn, int buffSize) {
        this.conn = conn;
        this.buffer = new byte[buffSize];
    }

    public void write(int b) throws IOException {
        if (this.numBytes == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.numBytes++] = (byte)b;
        if (b == -1) {
            this.write(0);
        }
    }

    public void writeClose() throws IOException {
        if (this.numBytes > this.buffer.length - 2) {
            this.flush();
        }
        this.buffer[this.numBytes++] = -1;
        this.buffer[this.numBytes++] = 1;
        this.flush();
    }

    public void flush() throws IOException {
        if (this.numBytes > 0) {
            if (this.conn.write(this.buffer, this.numBytes) < 0) {
                throw new IOException();
            }
            this.numBytes = 0;
        }
    }
}

