/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.ArrayList;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class ChoiceGroup
extends Item
implements Choice {
    protected int choiceType;
    protected ArrayList<ChoiceItem> choiceItems;
    private int scrollFirst = 0;
    private int scrollCurr = 0;
    private int scrollLast = 0;
    private boolean scrollWrap = true;

    public ChoiceGroup(String label, int choiceType) {
        if (choiceType == 3) {
            throw new IllegalArgumentException();
        }
        this.label = label;
        this.choiceType = choiceType;
        this.choiceItems = new ArrayList();
        this.interactive = true;
        if (label != null) {
            this.minWidth = label.length() * 6;
            this.minHeight = (choiceType == 4 ? 1 : 2) * 8;
        } else {
            this.minWidth = 6;
            this.minHeight = 8;
        }
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        if (choiceType == 3) {
            throw new IllegalArgumentException();
        }
        this.label = label;
        this.choiceType = choiceType;
        this.interactive = true;
        if (label != null) {
            this.minWidth = label.length() * 6;
            this.minHeight = 16;
        } else {
            this.minWidth = 6;
            this.minHeight = 8;
        }
        this.choiceItems = new ArrayList(stringElements.length);
        for (int i = 0; i < stringElements.length; ++i) {
            this.choiceItems.add(new ChoiceItem(stringElements != null && stringElements.length < i ? stringElements[i] : null, imageElements != null && imageElements.length < i ? imageElements[i] : null));
            int itemWidth = (stringElements != null && stringElements.length < i ? stringElements[i].length() * 6 : 0) + (imageElements != null && imageElements.length < i ? imageElements[i].getWidth() : 0);
            if (itemWidth > this.minWidth) {
                this.minWidth = itemWidth;
            }
            ++this.scrollLast;
        }
    }

    public int append(String stringPart, Image imagePart) {
        this.choiceItems.add(new ChoiceItem(stringPart, imagePart));
        int itemWidth = (stringPart != null ? stringPart.length() * 6 : 0) + (imagePart != null ? imagePart.getWidth() : 0);
        if (itemWidth > this.minWidth) {
            this.minWidth = itemWidth;
        }
        ++this.scrollLast;
        return this.choiceItems.size();
    }

    public void delete(int elementNum) {
        --this.scrollLast;
        this.choiceItems.remove(elementNum);
    }

    public void deleteAll() {
        this.scrollLast = 0;
        this.choiceItems.clear();
    }

    public Image getImage(int elementNum) {
        return this.choiceItems.get((int)elementNum).img;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        selectedArray_return = new boolean[this.choiceItems.size()];
        for (int i = 0; i < selectedArray_return.length; ++i) {
            selectedArray_return[i] = this.choiceItems.get((int)i).selected;
        }
        return selectedArray_return.length;
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.choiceItems.size(); ++i) {
            if (!this.choiceItems.get((int)i).selected) continue;
            return i;
        }
        return -1;
    }

    public String getString(int elementNum) {
        return this.choiceItems.get((int)elementNum).str;
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        this.choiceItems.add(elementNum, new ChoiceItem(stringPart, imagePart));
    }

    public boolean isSelected(int elementNum) {
        return this.choiceItems.get((int)elementNum).selected;
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        this.choiceItems.set(elementNum, new ChoiceItem(stringPart, imagePart));
    }

    public void setScrollWrap(boolean scrollWrap) {
        this.scrollWrap = scrollWrap;
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        for (int i = 0; i < this.choiceItems.size(); ++i) {
            this.choiceItems.get((int)i).selected = selectedArray[i];
        }
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        if (this.choiceType == 2 || !selected) {
            this.choiceItems.get((int)elementNum).selected = selected;
        } else {
            for (int i = 0; i < this.choiceItems.size(); ++i) {
                ChoiceItem li = this.choiceItems.get(i);
                li.selected = i == elementNum;
            }
        }
    }

    public int size() {
        return this.choiceItems.size();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 39) {
            if (this.scrollWrap) {
                this.scrollCurr = (this.scrollCurr + 1) % this.choiceItems.size();
            } else if (this.scrollCurr < this.choiceItems.size() - 1) {
                ++this.scrollCurr;
            }
            this.repaint();
        } else if (keyCode == 37) {
            if (this.scrollWrap) {
                this.scrollCurr = this.scrollCurr == 0 ? this.choiceItems.size() - 1 : this.scrollCurr - 1;
            } else if (this.scrollCurr > 0) {
                --this.scrollCurr;
            }
            this.repaint();
        } else if (keyCode != 40 && keyCode == 38) {
            ChoiceItem li = this.choiceItems.get(this.scrollCurr);
            this.setSelectedIndex(this.scrollCurr, !li.selected);
            this.notifyStateChanged();
        }
    }

    protected void paint(Graphics g, int x, int y, int w, int h, boolean selected) {
        if (this.label != null) {
            g.drawString(this.label, x, y, selected && this.choiceType == 4);
            y += 8;
            h -= 8;
        }
        if (h <= 0) {
            return;
        }
        int scrollLines = h / 8;
        if (this.scrollCurr == 0) {
            this.scrollFirst = 0;
            this.scrollLast = scrollLines;
        } else if (this.choiceItems.size() >= scrollLines && this.scrollCurr >= this.choiceItems.size() - 1) {
            this.scrollFirst = this.choiceItems.size() - scrollLines;
            this.scrollLast = this.choiceItems.size() - 1;
        } else if (this.scrollCurr >= this.scrollLast) {
            ++this.scrollFirst;
            ++this.scrollLast;
        } else if (this.scrollCurr < this.scrollFirst) {
            --this.scrollFirst;
            --this.scrollLast;
        }
        int xOffset = this.choiceType == 4 ? x : x + 12;
        for (int i = this.scrollFirst; i < this.choiceItems.size() && i <= this.scrollLast; ++i) {
            ChoiceItem li = this.choiceItems.get(i);
            g.drawString(li.str, xOffset, y, selected && i == this.scrollCurr);
            if (this.choiceType == 1 || this.choiceType == 2) {
                if (li.selected) {
                    g.fillArc(x, y, 8, 8, 0, 360);
                } else {
                    g.drawArc(x, y, 8, 8, 0, 360);
                }
            }
            y += 8;
            if ((h -= 8) <= 0) break;
        }
    }

    private class ChoiceItem {
        String str;
        Image img;
        boolean selected;

        ChoiceItem(String stringPart, Image imagePart) {
            this.str = stringPart;
            this.img = imagePart;
            this.selected = false;
        }
    }
}

