/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.ArrayList;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

public class Form
extends Screen
implements CommandListener {
    private static final Command EDIT_COMMAND = new Command(1, 1, 0);
    private ItemStateListener itemStateListener;
    private ArrayList<Object> items = new ArrayList();
    private int curItemIdx = 0;
    private boolean selectedItem;
    private int height;
    private int width;
    private TextBox editBox;

    public Form(String title) {
        this.title = title;
        this.editBox = new TextBox(null, null, 0, 1);
        this.editBox.setCommandListener(this);
        this.editBox.addCommand(EDIT_COMMAND);
    }

    public Form(String title, Item[] items) {
        this.title = title;
        for (int i = 0; items != null && i < items.length; ++i) {
            this.items.add(items[i]);
        }
    }

    public int append(Image img) {
        this.items.add(img);
        return this.items.size() - 1;
    }

    public int append(Item item) {
        this.items.add(item);
        return this.items.size() - 1;
    }

    public int append(String str) {
        this.items.add(str);
        return this.items.size() - 1;
    }

    public void delete(int itemNum) {
        this.items.remove(itemNum);
    }

    public void deleteAll() {
        this.items.clear();
    }

    public Object get(int itemNum) {
        return this.items.get(itemNum);
    }

    public void set(int itemNum, Item item) {
        this.items.set(itemNum, item);
    }

    public void insert(int itemNum, Item item) {
        this.items.add(itemNum, item);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int size() {
        return this.items.size();
    }

    public void setItemStateListener(ItemStateListener i) {
        this.itemStateListener = i;
    }

    protected void callItemStateListener() {
        Object o = this.items.get(this.curItemIdx);
        if (this.itemStateListener != null && o instanceof Item) {
            this.itemStateListener.itemStateChanged((Item)o);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.selectedItem && this.curItemIdx >= 0) {
            if (keyCode == 39 || keyCode == 37 || keyCode == 38) {
                ((Item)this.items.get(this.curItemIdx)).keyPressed(keyCode);
            } else if (keyCode == 40) {
                Object o = this.items.get(this.curItemIdx);
                if (o instanceof TextField) {
                    this.editBox.keyPressed(keyCode);
                } else {
                    this.callItemStateListener();
                    this.selectedItem = false;
                }
            }
        } else if (keyCode == 39) {
            for (int i = this.curItemIdx + 1; i != this.curItemIdx; ++i) {
                Object o;
                if (i >= this.items.size()) {
                    i = 0;
                }
                if (!((o = this.items.get(i)) instanceof Item) || !((Item)o).isInteractive()) continue;
                this.curItemIdx = i;
                break;
            }
        } else if (keyCode == 37) {
            for (int i = this.curItemIdx - 1; i != this.curItemIdx; --i) {
                Object o;
                if (i < 0) {
                    i = this.items.size() - 1;
                }
                if (!((o = this.items.get(i)) instanceof Item) || !((Item)o).isInteractive()) continue;
                this.curItemIdx = i;
                break;
            }
        } else if (keyCode == 40) {
            for (int i = 0; i < this.commands.size(); ++i) {
                this.callCommandListener();
            }
        } else if (keyCode == 38) {
            Object o = this.items.get(this.curItemIdx);
            if (o instanceof TextField) {
                this.editBox.setTitle(((TextField)o).getLabel());
                this.editBox.setText(((TextField)o).getText());
                this.editBox.setMaxSize(((TextField)o).getMaxSize());
                this.editBox.setConstraints(((TextField)o).getConstraints());
                Display.getDisplay().setCurrent(this.editBox);
            } else {
                this.selectedItem = true;
            }
        }
        this.repaint();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == EDIT_COMMAND && d == this.editBox) {
            TextField tf = (TextField)this.items.get(this.curItemIdx);
            tf.setText(this.editBox.getText());
            this.callItemStateListener();
            Display.getDisplay().setCurrent(this);
        }
    }

    public void paint(Graphics g) {
        int curX = 0;
        int curY = 0;
        ChoiceGroup activePopup = null;
        int popupX = 0;
        int popupY = 0;
        if (this.title != null) {
            g.drawString(this.title, 0, 0);
            curY += 8;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            Object o;
            int curWidth = this.getItemWidth(i);
            int curHeight = this.getItemHeight(i);
            if (curX + curWidth < 100 && curX + curWidth + this.getItemWidth(i + 1) > 100) {
                curWidth = 100 - curX;
            }
            if ((o = this.items.get(i)) instanceof Image) {
                g.drawImage((Image)o, curX, curY, false);
            } else if (o instanceof String) {
                g.drawString((String)o, curX, curY);
            } else if (o instanceof Item) {
                ((Item)o).paint(g, curX, curY, curWidth, curHeight, i == this.curItemIdx);
                if (this.selectedItem && i == this.curItemIdx && o instanceof ChoiceGroup && ((ChoiceGroup)o).choiceType == 4) {
                    activePopup = (ChoiceGroup)o;
                    popupX = curX;
                    popupY = curY;
                }
            }
            if (curX + curWidth < 100) {
                curX += curWidth;
                if (curHeight <= 8) continue;
                curY += curHeight - 8;
                continue;
            }
            curX = 0;
            curY += curHeight;
        }
        if (activePopup != null) {
            int popupHeight = (activePopup.label != null ? 8 : 0) + activePopup.size() * 8;
            if (popupY + popupHeight > 64) {
                popupHeight = 64 - popupY;
            }
            activePopup.paint(g, popupX, popupY, activePopup.getMinimumWidth(), popupHeight, true);
        }
    }

    private int getItemWidth(int itemIdx) {
        if (itemIdx >= this.items.size()) {
            return 0;
        }
        Object o = this.items.get(itemIdx);
        if (o instanceof Image) {
            return ((Image)o).getWidth();
        }
        if (o instanceof String) {
            return ((String)o).length() * 6;
        }
        if (o instanceof Item) {
            return Math.max(((Item)o).getMinimumWidth(), ((Item)o).getPreferredWidth());
        }
        return 0;
    }

    private int getItemHeight(int itemIdx) {
        if (itemIdx >= this.items.size()) {
            return 0;
        }
        Object o = this.items.get(itemIdx);
        int height = 0;
        if (o instanceof Image) {
            height = ((Image)o).getHeight();
        } else if (o instanceof String) {
            height = 8;
        } else if (o instanceof Item) {
            height = Math.max(((Item)o).getMinimumHeight(), ((Item)o).getPreferredHeight());
        }
        height = (height + 8 - 1) / 8 * 8;
        return height;
    }
}

