/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import java.io.IOException;
import java.io.InputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.ProximityListener;
import javax.microedition.location.QualifiedCoordinates;
import lejos.addon.gps.GPSListener;
import lejos.addon.gps.NMEASentence;
import lejos.addon.gps.SimpleGPS;

class BTGPSLocationProvider
extends LocationProvider
implements DiscoveryListener,
GPSListener {
    SimpleGPS gps = null;
    DiscoveryAgent da;
    RemoteDevice btDevice = null;
    private Thread listyThread = null;
    private boolean listenerRunning = true;
    private GPSListener gpsl = null;
    boolean doneInq = false;
    private static final int GPS_MAJOR = 7936;

    protected BTGPSLocationProvider() throws LocationException {
        try {
            this.da = LocalDevice.getLocalDevice().getDiscoveryAgent();
            this.da.startInquiry(10390323, this);
        }
        catch (BluetoothStateException e) {
            throw new LocationException(e.getMessage());
        }
        while (!this.doneInq) {
            Thread.yield();
        }
        if (this.btDevice == null) {
            throw new LocationException("No device found");
        }
        String address = this.btDevice.getBluetoothAddress();
        String btaddy = "btspp://" + address;
        try {
            StreamConnectionNotifier scn = (StreamConnectionNotifier)Connector.open(btaddy);
            if (scn == null) {
                throw new LocationException("Bad BT address");
            }
            StreamConnection c = scn.acceptAndOpen();
            if (c == null) {
                throw new LocationException("Failed. Try pairing at menu again");
            }
            InputStream in = c.openInputStream();
            if (in != null) {
                this.gps = new SimpleGPS(in);
            }
        }
        catch (IOException e) {
            throw new LocationException(e.getMessage());
        }
        SimpleGPS.addListener(this);
    }

    public Location getLocation(int timeout) throws LocationException, InterruptedException {
        if (timeout == 0) {
            throw new IllegalArgumentException("timeout cannot equal 0");
        }
        long startTime = System.currentTimeMillis();
        while (this.gps.getLatitude() == 0.0 & this.gps.getLongitude() == 0.0) {
            if (timeout != -1 & System.currentTimeMillis() - startTime > (long)(timeout * 1000)) {
                throw new LocationException("GPS timed out");
            }
            Thread.sleep(100L);
        }
        QualifiedCoordinates qc = new QualifiedCoordinates(this.gps.getLatitude(), this.gps.getLongitude(), this.gps.getAltitude(), this.gps.getHDOP() * 6.0f, this.gps.getVDOP() * 6.0f);
        Location loc = new Location(qc, this.gps.getSpeed(), this.gps.getCourse(), this.gps.getTimeStamp(), 0, null);
        return loc;
    }

    public int getState() {
        return 0;
    }

    public void reset() {
    }

    public void setLocationListener(LocationListener listener, int interval, int timeout, int maxAge) {
        this.listenerRunning = false;
        if (this.listyThread != null) {
            while (this.listyThread.isAlive()) {
                Thread.yield();
            }
            this.listyThread = null;
        }
        if (listener == null) {
            SimpleGPS.removeListener(this.gpsl);
            this.gpsl = null;
            return;
        }
        final int to = timeout;
        final LocationListener l = listener;
        final BTGPSLocationProvider lp = this;
        final int delay = interval * 1000;
        if (interval > 0) {
            this.listyThread = new Thread(){

                public void run() {
                    while (BTGPSLocationProvider.this.listenerRunning) {
                        try {
                            l.locationUpdated(lp, lp.getLocation(to));
                            Thread.sleep(delay);
                        }
                        catch (LocationException e) {
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            this.listyThread.setDaemon(true);
            this.listenerRunning = true;
            this.listyThread.start();
        } else if (interval < 0) {
            this.gpsl = new GPSListener(){

                public void sentenceReceived(NMEASentence sen) {
                    if (sen.getHeader().equals("$GPGGA")) {
                        try {
                            l.locationUpdated(lp, lp.getLocation(to));
                        }
                        catch (LocationException e) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            SimpleGPS.addListener(this.gpsl);
        }
    }

    public void sentenceReceived(NMEASentence sen) {
        if (sen.getHeader().equals("$GPGGA")) {
            QualifiedCoordinates cur = null;
            Location loc = null;
            try {
                loc = this.getLocation(-1);
                cur = loc.getQualifiedCoordinates();
            }
            catch (InterruptedException e) {
                System.err.println("Fail 1");
            }
            catch (LocationException e) {
                System.err.println("Fail 2");
            }
            for (int i = 0; i < listeners.size(); ++i) {
                Object[] array = (Object[])listeners.elementAt(i);
                ProximityListener pl = (ProximityListener)array[0];
                Coordinates to = (Coordinates)array[1];
                Float rad = (Float)array[2];
                if (!(cur.distance(to) <= (double)rad.floatValue())) continue;
                LocationProvider.removeProximityListener(pl);
                pl.proximityEvent(to, loc);
            }
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if ((cod.getMajorDeviceClass() & 0x1F00) == 7936 && btDevice.isAuthenticated()) {
            this.btDevice = btDevice;
            this.da.cancelInquiry(this);
        }
    }

    public void inquiryCompleted(int discType) {
        this.doneInq = true;
    }
}

