/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import lejos.addon.gps.NMEASentence;

public class GGASentence
extends NMEASentence {
    private float dateTimeOfFix = -1.0f;
    private double latitude = 0.0;
    private char latitudeDirection;
    private double longitude = 0.0;
    private char longitudeDirection;
    private float quality;
    private float satellitesTracked = 0.0f;
    private float hdop = 0.0f;
    private float altitude = 0.0f;
    private String altitudeUnits;
    private float geoidalSeparation;
    private String geoidalSeparationUnit;
    public static final String HEADER = "$GPGGA";

    public String getHeader() {
        return HEADER;
    }

    public double getLatitude() {
        this.checkRefresh();
        return this.latitude;
    }

    public char getLatitudeDirection() {
        this.checkRefresh();
        return this.latitudeDirection;
    }

    public double getLongitude() {
        this.checkRefresh();
        return this.longitude;
    }

    public char getLongitudeDirection() {
        this.checkRefresh();
        return this.longitudeDirection;
    }

    public float getAltitude() {
        this.checkRefresh();
        return this.altitude;
    }

    public int getTime() {
        this.checkRefresh();
        return Math.round(this.dateTimeOfFix);
    }

    public int getSatellitesTracked() {
        this.checkRefresh();
        return Math.round(this.satellitesTracked);
    }

    public int getFixQuality() {
        this.checkRefresh();
        return Math.round(this.quality);
    }

    protected void parse(String sentence) {
        this.st = new StringTokenizer(sentence, ",");
        String q = "";
        String h = "";
        try {
            this.st.nextToken();
            this.dateTimeOfFix = Float.parseFloat(this.st.nextToken());
            this.latitude = this.degreesMinToDegrees(this.st.nextToken());
            this.latitudeDirection = this.st.nextToken().charAt(0);
            this.longitude = this.degreesMinToDegrees(this.st.nextToken());
            this.longitudeDirection = this.st.nextToken().charAt(0);
            q = this.st.nextToken();
            this.quality = q.length() == 0 ? 0.0f : Float.parseFloat(q);
            this.satellitesTracked = Float.parseFloat(this.st.nextToken());
            h = this.st.nextToken();
            this.hdop = h.length() == 0 ? 0.0f : Float.parseFloat(h);
            this.altitude = Float.parseFloat(this.st.nextToken());
            if (this.longitudeDirection != 'E') {
                this.longitude = -this.longitude;
            }
            if (this.latitudeDirection != 'N') {
                this.latitude = -this.latitude;
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("GGASentence.parse() NoSuchElementException thrown: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            System.err.println("GGASentence.parse() NumberFormatException thrown: " + e.getMessage());
        }
    }
}

