/*
 * Decompiled with CFR 0.152.
 */
package lejos.addon.gps;

import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import lejos.addon.gps.GSVSentence;
import lejos.addon.gps.RMCSentence;
import lejos.addon.gps.Satellite;
import lejos.addon.gps.SimpleGPS;

public class GPS
extends SimpleGPS {
    private RMCSentence rmcSentence = new RMCSentence();
    private GSVSentence gsvSentence = new GSVSentence();
    private int gsvSentenceNumber = -1;
    private int gsvSentenceTotal = -1;
    private Date date = new Date();

    public GPS(InputStream in) {
        super(in);
    }

    public float getCompassDegrees() {
        return this.rmcSentence.getCompassDegrees();
    }

    public Date getDate() {
        this.updateDate();
        this.updateTime();
        return this.date;
    }

    public Satellite getSatellite(int index) {
        Satellite s = this.gsvSentence.getSatellite(index);
        boolean tracked = false;
        int i = 0;
        int[] prns = this.getPRN();
        if (i < prns.length && prns[i] == s.getPRN()) {
            tracked = true;
        }
        s.setTracked(tracked);
        return s;
    }

    public int getSatellitesTracked() {
        return this.ggaSentence.getSatellitesTracked();
    }

    public int getSatellitesInView() {
        return this.gsvSentence.getSatellitesInView();
    }

    protected void sentenceChooser(String header, String s) {
        if (header.equals("$GPRMC")) {
            this.rmcSentence.setSentence(s);
            GPS.notifyListeners(this.rmcSentence);
        } else if (header.equals("$GPGSV")) {
            StringTokenizer st = new StringTokenizer(s, ",");
            st.nextToken();
            this.gsvSentenceTotal = Integer.parseInt(st.nextToken());
            this.gsvSentenceNumber = Integer.parseInt(st.nextToken());
            this.gsvSentence.setSentence(s, this.gsvSentenceNumber, this.gsvSentenceTotal);
            if (this.gsvSentenceTotal == this.gsvSentenceNumber) {
                this.gsvSentence.setSentence(s);
                GPS.notifyListeners(this.gsvSentence);
            }
        } else {
            super.sentenceChooser(header, s);
        }
    }

    private void updateTime() {
        int timeStamp = this.ggaSentence.getTime();
        if (timeStamp > 0) {
            String rt = Integer.toString(timeStamp);
            int hh = Integer.parseInt(rt.substring(0, rt.length() - 4));
            int mm = Integer.parseInt(rt.substring(rt.length() - 4, rt.length() - 2));
            int ss = Integer.parseInt(rt.substring(rt.length() - 2, rt.length()));
            this.date.setHours(hh);
            this.date.setMinutes(mm);
            this.date.setSeconds(ss);
        }
    }

    private void updateDate() {
        int dateStamp = this.rmcSentence.getDate();
        if (dateStamp > 0) {
            String rd = Integer.toString(dateStamp);
            int dd = Integer.parseInt(rd.substring(0, rd.length() - 4));
            int mm = Integer.parseInt(rd.substring(rd.length() - 4, rd.length() - 2));
            int yy = Integer.parseInt(rd.substring(rd.length() - 2, rd.length()));
            this.date.setDay(dd);
            this.date.setMonth(mm);
            this.date.setYear(yy);
        }
    }
}

