/*
 * Decompiled with CFR 0.152.
 */
package lejos.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import lejos.charset.CharsetEncoder;

public class LejosOutputStreamWriter
extends Writer {
    private static final int MIN_BUFFERSIZE = 16;
    private final CharsetEncoder coder;
    private final OutputStream os;
    private final byte[] buffer;
    private final int limit;
    private char high;

    public LejosOutputStreamWriter(OutputStream os, CharsetEncoder coder, int buffersize) {
        this.os = os;
        this.coder = coder;
        if (buffersize < 16) {
            buffersize = 16;
        }
        if (coder.getMaxCharLength() > buffersize) {
            throw new IllegalArgumentException("buffer to small for given charset");
        }
        this.buffer = new byte[buffersize];
        this.limit = buffersize - coder.getMaxCharLength();
    }

    private int writeChar(int len, char c) throws IOException {
        int cp;
        if (Character.isHighSurrogate((char)c)) {
            if (this.high > '\u0000') {
                len = this.coder.encode(-1, this.buffer, len);
            }
            this.high = c;
            return len;
        }
        if (!Character.isLowSurrogate((char)c)) {
            cp = c;
        } else {
            if (this.high == '\u0000') {
                return this.coder.encode(-1, this.buffer, len);
            }
            cp = Character.toCodePoint(this.high, (char)c);
            this.high = '\u0000';
        }
        if (len >= this.limit) {
            this.bufferFlush(len);
            len = 0;
        }
        return this.coder.encode(cp, this.buffer, len);
    }

    private void bufferFlush(int len) throws IOException {
        this.os.write(this.buffer, 0, len);
    }

    public Writer append(char c) throws IOException {
        this.bufferFlush(this.writeChar(0, c));
        return this;
    }

    public Writer append(CharSequence str, int start, int end) throws IOException {
        int bl = 0;
        for (int i = start; i < end; ++i) {
            bl = this.writeChar(bl, str.charAt(i));
        }
        this.bufferFlush(bl);
        return this;
    }

    public void write(int c) throws IOException {
        this.bufferFlush(this.writeChar(0, (char)c));
    }

    public void write(String str, int off, int len) throws IOException {
        int bl = 0;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            bl = this.writeChar(bl, str.charAt(i));
        }
        this.bufferFlush(bl);
    }

    public void write(char[] c, int off, int len) throws IOException {
        int bl = 0;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            bl = this.writeChar(bl, c[i]);
        }
        this.bufferFlush(bl);
    }

    public void close() throws IOException {
        if (this.high > '\u0000') {
            this.high = '\u0000';
            this.bufferFlush(this.coder.encode(-1, this.buffer, 0));
        }
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }
}

