/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.SensorConstants;
import lejos.nxt.SensorPort;
import lejos.robotics.ColorDetector;
import lejos.robotics.Colors;
import lejos.robotics.LampLightDetector;

public class ColorLightSensor
implements LampLightDetector,
ColorDetector,
SensorConstants {
    protected Colors.Color[] colorMap = Colors.Color.values();
    protected SensorPort port;
    protected int type;
    private int _zero = 1023;
    private int _hundred = 0;
    private Colors.Color lampColor = Colors.Color.NONE;

    public ColorLightSensor(SensorPort port, int type) {
        this.port = port;
        port.enableColorSensor();
        port.setTypeAndMode(type, 0);
    }

    public void setType(int type) {
        this.port.setType(type);
        this.type = type;
    }

    public int readRawValue() {
        return this.port.readRawValue();
    }

    public int readRawValues(int[] vals) {
        return this.port.readRawValues(vals);
    }

    public int readValues(int[] vals) {
        return this.port.readValues(vals);
    }

    public int readValue() {
        return this.port.readValue();
    }

    public Colors.Color readColor() {
        int col = this.readValue();
        if (col <= 0) {
            return Colors.Color.NONE;
        }
        return this.colorMap[col];
    }

    public int getLightValue() {
        int temp_type = this.type;
        this.setType(17);
        int val = this.readValue();
        this.setType(temp_type);
        return val;
    }

    public int getNormalizedLightValue() {
        int temp_type = this.type;
        this.setType(17);
        int val = this.readRawValue();
        this.setType(temp_type);
        return val;
    }

    public void setFloodlight(boolean floodlight) {
        this.lampColor = floodlight ? Colors.Color.RED : Colors.Color.NONE;
        this.setType(floodlight ? 14 : 17);
    }

    public int getBlueComponent() {
        int temp_type = this.type;
        this.setType(16);
        int val = this.readRawValue();
        val = val * 255 / 1023;
        this.setType(temp_type);
        return val;
    }

    public int getGreenComponent() {
        int temp_type = this.type;
        this.setType(15);
        int val = this.readRawValue();
        val = val * 255 / 1023;
        this.setType(temp_type);
        return val;
    }

    public int[] getColor() {
        int temp_type = this.type;
        this.setType(13);
        int[] all_vals = new int[4];
        this.readValues(all_vals);
        int[] rgb_vals = new int[3];
        System.arraycopy(all_vals, 0, rgb_vals, 0, 3);
        this.setType(temp_type);
        return rgb_vals;
    }

    public int getRedComponent() {
        int temp_type = this.type;
        this.setType(14);
        int val = this.readRawValue();
        val = val * 255 / 1023;
        this.setType(temp_type);
        return val;
    }

    public Colors.Color getFloodlight() {
        return this.lampColor;
    }

    public boolean isFloodlightOn() {
        return this.lampColor != Colors.Color.NONE;
    }

    public boolean setFloodlight(Colors.Color color) {
        if (color == Colors.Color.RED) {
            this.lampColor = color;
            this.setType(14);
            return true;
        }
        if (color == Colors.Color.BLUE) {
            this.lampColor = color;
            this.setType(16);
            return true;
        }
        if (color == Colors.Color.GREEN) {
            this.lampColor = color;
            this.setType(15);
            return true;
        }
        if (color == Colors.Color.NONE) {
            this.lampColor = color;
            this.setType(17);
            return true;
        }
        return false;
    }

    public void calibrateLow() {
        this._zero = this.port.readRawValue();
    }

    public void calibrateHigh() {
        this._hundred = this.port.readRawValue();
    }

    public void setLow(int low) {
        this._zero = 1023 - low;
    }

    public void setHigh(int high) {
        this._hundred = 1023 - high;
    }

    public int getLow() {
        return 1023 - this._zero;
    }

    public int getHigh() {
        return 1023 - this._hundred;
    }
}

