/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.LegacySensorPort;
import lejos.nxt.ListenerCaller;
import lejos.nxt.ListenerThread;
import lejos.nxt.SensorPortListener;
import lejos.robotics.Colors;
import lejos.util.Delay;

public class SensorPort
implements LegacySensorPort,
I2CPort,
ListenerCaller {
    public static final int POWER_STD = 0;
    public static final int POWER_RCX9V = 1;
    public static final int POWER_9V = 2;
    public static final int SP_DIGI0 = 0;
    public static final int SP_DIGI1 = 1;
    public static final int SP_ANA = 2;
    public static final int SP_MODE_OFF = 0;
    public static final int SP_MODE_INPUT = 1;
    public static final int SP_MODE_OUTPUT = 2;
    public static final int SP_MODE_ADC = 3;
    public static final int DIGI_UNUSED = -1;
    public static final int DIGI_OFF = 0;
    public static final int DIGI_0_ON = 1;
    public static final int DIGI_1_ON = 2;
    private static final byte[] powerType = new byte[]{0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0};
    private static final byte[] controlPins = new byte[]{-1, -1, -1, -1, -1, 1, 0, 1, 2, -1, -1, -1, -1, 0, 0, 0, 0, 0};
    public static final SensorPort S1 = new SensorPort(0);
    public static final SensorPort S2 = new SensorPort(1);
    public static final SensorPort S3 = new SensorPort(2);
    public static final SensorPort S4 = new SensorPort(3);
    public static final SensorPort[] PORTS = new SensorPort[]{S1, S2, S3, S4};
    private int iPortId;
    private short iNumListeners = 0;
    private SensorPortListener[] iListeners;
    private int iPreviousValue;
    private int type;
    private int mode;
    private SensorReader offReader = new SensorReader();
    private SensorReader standardReader = new StandardReader();
    private SensorReader colorReader = null;
    private SensorReader curReader = this.offReader;

    public void enableColorSensor() {
        if (this.colorReader != null) {
            return;
        }
        this.colorReader = new ColorSensorReader();
        this.reset();
    }

    protected SensorPort(int aId) {
        this.iPortId = aId;
        this.reset();
    }

    public void reset() {
        this.standardReader.reset();
        if (this.colorReader != null) {
            this.colorReader.reset();
        }
        this.type = -1;
        this.mode = 0;
        this.curReader = this.offReader;
        this.setType(0);
    }

    public final int getId() {
        return this.iPortId;
    }

    public synchronized void addSensorPortListener(SensorPortListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new SensorPortListener[8];
        }
        short s = this.iNumListeners;
        this.iNumListeners = (short)(s + 1);
        this.iListeners[s] = aListener;
        ListenerThread.get().addSensorToMask(this.iPortId, this);
    }

    public final void activate() {
        this.setPowerType(1);
    }

    public final void passivate() {
        this.setPowerType(0);
    }

    public int getMode() {
        return this.mode;
    }

    public int getType() {
        return this.type;
    }

    public void setTypeAndMode(int type, int mode) {
        this.setType(type);
        this.setMode(mode);
    }

    public void setType(int newType) {
        if (newType == this.type) {
            return;
        }
        if (newType < powerType.length) {
            SensorReader newReader = newType >= 13 ? this.colorReader : (newType >= 1 ? this.standardReader : this.offReader);
            if (newReader == null) {
                newReader = this.offReader;
            }
            if (newReader != this.curReader) {
                this.curReader.setType(0);
            }
            byte control = controlPins[newType];
            this.setPowerType(powerType[newType]);
            this.setSensorPinMode(0, 2);
            this.setSensorPinMode(1, 2);
            if (control == -1) {
                control = 0;
            }
            this.setSensorPin(0, (control & 1) != 0 ? 1 : 0);
            this.setSensorPin(1, (control & 2) != 0 ? 1 : 0);
            this.type = newType;
            this.curReader = newReader;
            newReader.setType(newType);
            newReader.setMode(this.mode);
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.curReader.setMode(mode);
    }

    public final int readRawValue() {
        return this.curReader.readRawValue();
    }

    public int readValue() {
        return this.curReader.readValue();
    }

    public int readValues(int[] values) {
        return this.curReader.readValues(values);
    }

    public int readRawValues(int[] values) {
        return this.curReader.readRawValues(values);
    }

    public final boolean readBooleanValue() {
        int rawValue = this.readRawValue();
        return rawValue < 600;
    }

    static native int readSensorValue(int var0);

    public void setPowerType(int type) {
        SensorPort.setPowerTypeById(this.iPortId, type);
    }

    static native void setPowerTypeById(int var0, int var1);

    public synchronized void callListeners() {
        int newValue = SensorPort.readSensorValue(this.iPortId);
        for (int i = 0; i < this.iNumListeners; ++i) {
            this.iListeners[i].stateChanged(this, this.iPreviousValue, newValue);
        }
        this.iPreviousValue = newValue;
    }

    public static native void i2cEnableById(int var0, int var1);

    public static native void i2cDisableById(int var0);

    public static native int i2cBusyById(int var0);

    public static native int i2cStartById(int var0, int var1, int var2, int var3, byte[] var4, int var5, int var6);

    public static native int i2cCompleteById(int var0, byte[] var1, int var2);

    public void i2cEnable(int mode) {
        SensorPort.i2cEnableById(this.iPortId, mode);
    }

    public void i2cDisable() {
        SensorPort.i2cDisableById(this.iPortId);
    }

    public int i2cBusy() {
        return SensorPort.i2cBusyById(this.iPortId);
    }

    public int i2cStart(int address, int internalAddress, int numInternalBytes, byte[] buffer, int numBytes, int transferType) {
        return SensorPort.i2cStartById(this.iPortId, address, internalAddress, numInternalBytes, buffer, numBytes, transferType);
    }

    public int i2cComplete(byte[] buffer, int numBytes) {
        return SensorPort.i2cCompleteById(this.iPortId, buffer, numBytes);
    }

    static native void setSensorPinMode(int var0, int var1, int var2);

    static native void setSensorPin(int var0, int var1, int var2);

    static native int getSensorPin(int var0, int var1);

    static native int readSensorPin(int var0, int var1);

    public void setSensorPinMode(int pin, int mode) {
        SensorPort.setSensorPinMode(this.iPortId, pin, mode);
    }

    public void setSensorPin(int pin, int val) {
        SensorPort.setSensorPin(this.iPortId, pin, val);
    }

    public int getSensorPin(int pin) {
        return SensorPort.getSensorPin(this.iPortId, pin);
    }

    public int readSensorPin(int pin) {
        return SensorPort.readSensorPin(this.iPortId, pin);
    }

    protected class ColorSensorReader
    extends SensorReader {
        public static final int RGB_RED = 0;
        public static final int RGB_GREEN = 1;
        public static final int RGB_BLUE = 2;
        public static final int RGB_BLANK = 3;
        protected Colors.Color[] colorMap;
        protected static final int CLOCK = 0;
        protected static final int DATA = 1;
        protected boolean initialized;
        protected int type;
        protected static final int ADVOLTS = 3300;
        protected static final int ADMAX = 1023;
        protected static final int MINBLANKVAL = 71;
        protected static final int SENSORMAX = 1023;
        protected int[][] calData;
        protected int[] calLimits;
        protected int[] rawValues;
        protected int[] values;

        public ColorSensorReader() {
            this.colorMap = Colors.Color.values();
            this.initialized = false;
            this.type = 0;
            this.calData = new int[3][4];
            this.calLimits = new int[2];
            this.rawValues = new int[4];
            this.values = new int[4];
            this.initialized = false;
        }

        protected void initValues() {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = 0;
                this.rawValues[i] = 0;
            }
        }

        public void setType(int type) {
            if (type != 0) {
                if (this.type != type) {
                    this.type = type;
                    this.initialized = false;
                    this.checkInitialized();
                }
            } else {
                this.reset();
            }
        }

        public void reset() {
            this.setType(17);
            this.type = 0;
        }

        protected void setClock(int val) {
            SensorPort.this.setSensorPin(0, val);
        }

        protected void setData(int val) {
            SensorPort.this.setSensorPin(1, val);
        }

        protected boolean getData() {
            return SensorPort.this.getSensorPin(1) != 0;
        }

        protected int readData() {
            return SensorPort.this.readSensorPin(1);
        }

        protected void resetSensor() {
            this.setClock(1);
            this.setData(1);
            SensorPort.this.setSensorPinMode(0, 2);
            SensorPort.this.setSensorPinMode(1, 2);
            Delay.msDelay(1L);
            this.setClock(0);
            Delay.msDelay(1L);
            this.setClock(1);
            Delay.msDelay(1L);
            this.setClock(0);
            Delay.msDelay(100L);
        }

        protected void sendMode(int mode) {
            for (int i = 0; i < 8; ++i) {
                this.setClock(1);
                this.setData(mode & 1);
                Delay.usDelay(30L);
                this.setClock(0);
                mode >>= 1;
                Delay.usDelay(30L);
            }
        }

        protected int readByte() {
            int val = 0;
            for (int i = 0; i < 8; ++i) {
                this.setClock(1);
                Delay.usDelay(4L);
                val >>= 1;
                if (this.getData()) {
                    val |= 0x80;
                }
                this.setClock(0);
                Delay.usDelay(4L);
            }
            return val;
        }

        protected int calcCRC(int crc, int val) {
            for (int i = 0; i < 8; ++i) {
                crc = ((val ^ crc) & 1) != 0 ? crc >>> 1 ^ 0xA001 : (crc >>>= 1);
                val >>>= 1;
            }
            return crc & 0xFFFF;
        }

        protected boolean readCalibration() {
            int input;
            int i;
            SensorPort.this.setSensorPinMode(1, 1);
            int crcVal = 23205;
            for (i = 0; i < this.calData.length; ++i) {
                for (int col = 0; col < this.calData[i].length; ++col) {
                    int val = 0;
                    int shift = 0;
                    for (int k = 0; k < 4; ++k) {
                        input = this.readByte();
                        crcVal = this.calcCRC(crcVal, input);
                        val |= input << shift;
                        shift += 8;
                    }
                    this.calData[i][col] = val;
                }
            }
            for (i = 0; i < this.calLimits.length; ++i) {
                int val = 0;
                int shift = 0;
                for (int k = 0; k < 2; ++k) {
                    input = this.readByte();
                    crcVal = this.calcCRC(crcVal, input);
                    val |= input << shift;
                    shift += 8;
                }
                this.calLimits[i] = val;
            }
            int crc = this.readByte() << 8;
            SensorPort.this.setSensorPinMode(1, 3);
            Delay.msDelay(1L);
            return (crc += (short)this.readByte()) == crcVal;
        }

        protected boolean initSensor(int mode) {
            this.resetSensor();
            this.sendMode(mode);
            return this.readCalibration();
        }

        protected boolean checkPresent() {
            int ANAValue = SensorPort.this.readSensorPin(2);
            return ANAValue <= 50;
        }

        protected boolean checkInitialized() {
            int ANAValue = SensorPort.this.readSensorPin(2);
            if (ANAValue > 50) {
                this.initialized = false;
            } else if (!this.initialized) {
                this.initialized = this.initSensor(this.type);
            }
            return this.initialized;
        }

        protected boolean checkSensor() {
            SensorPort.this.setSensorPinMode(0, 1);
            Delay.msDelay(2L);
            if (SensorPort.this.getSensorPin(0) != 0) {
                this.initialized = false;
            }
            return this.initialized;
        }

        protected int readFullColorValue(int newClock) {
            int val = SensorPort.this.readSensorPin(1);
            int val2 = SensorPort.this.readSensorPin(1);
            this.setClock(newClock);
            return (val + val2) / 2;
        }

        protected boolean readSensor() {
            if (!this.checkInitialized()) {
                return false;
            }
            if (this.type == 13) {
                if (!this.checkSensor()) {
                    return false;
                }
                SensorPort.this.setSensorPinMode(0, 2);
                this.rawValues[3] = this.readFullColorValue(1);
                this.rawValues[0] = this.readFullColorValue(0);
                this.rawValues[1] = this.readFullColorValue(1);
                this.rawValues[2] = this.readFullColorValue(0);
                return true;
            }
            if (!this.checkSensor()) {
                return false;
            }
            this.rawValues[this.type - 14] = this.readData();
            return true;
        }

        public int readRawValue() {
            if (this.type < 14) {
                return -1;
            }
            if (!this.readSensor()) {
                return -1;
            }
            return this.rawValues[this.type - 14];
        }

        public int readRawValues(int[] vals) {
            if (this.type != 13) {
                return -1;
            }
            if (!this.readSensor()) {
                return -1;
            }
            System.arraycopy(this.rawValues, 0, vals, 0, this.rawValues.length);
            return this.rawValues.length;
        }

        protected void calibrate(int[] vals) {
            int blankVal = this.rawValues[3];
            int calTab = blankVal < this.calLimits[1] ? 2 : (blankVal < this.calLimits[0] ? 1 : 0);
            for (int col = 0; col <= 2; ++col) {
                vals[col] = this.rawValues[col] > blankVal ? (this.rawValues[col] - blankVal) * this.calData[calTab][col] >>> 16 : 0;
            }
            blankVal = blankVal > 71 ? (blankVal -= 71) : 0;
            blankVal = blankVal * 100 / 93;
            vals[3] = blankVal * this.calData[calTab][3] >>> 16;
        }

        public int readValues(int[] vals) {
            if (this.type != 13) {
                return -1;
            }
            if (!this.readSensor()) {
                return -1;
            }
            this.calibrate(vals);
            return 4;
        }

        public int readValue() {
            if (!this.readSensor()) {
                return -1;
            }
            if (this.type >= 14) {
                return this.rawValues[this.type - 14] * 100 / 1023;
            }
            this.calibrate(this.values);
            int red = this.values[0];
            int blue = this.values[2];
            int green = this.values[1];
            int blank = this.values[3];
            if (red < 55 && green < 55 && blue < 55 || blank < 30 && red < 100 && green < 100 && blue < 100) {
                return 1;
            }
            if (red > blue && red > green) {
                if ((blue >> 1) + (blue >> 2) + blue < green && (green << 1) + green > red) {
                    return 4;
                }
                if (green << 1 < red) {
                    return 5;
                }
                if (blue < 70 || green < 70 || blank < 100 && red < 100) {
                    return 1;
                }
                return 6;
            }
            if (green > blue) {
                if (blue << 1 < red) {
                    return 4;
                }
                if (red + (red >> 2) + (red >> 3) < green || blue + (blue >> 2) + (blue >> 3) < green) {
                    return 3;
                }
                if (red < 70 || blue < 70 || blank < 100 && green < 100) {
                    return 1;
                }
                return 6;
            }
            if (red + (red >> 3) + (red >> 4) < blue || (green + green >> 3) + (green >> 4) < blue) {
                return 2;
            }
            if (red < 70 || green < 70 || blank < 100 && blue < 100) {
                return 1;
            }
            return 6;
        }
    }

    protected class StandardReader
    extends SensorReader {
        protected StandardReader() {
        }

        public int readValue() {
            int rawValue = SensorPort.readSensorValue(SensorPort.this.iPortId);
            if (SensorPort.this.mode == 32) {
                return rawValue < 600 ? 1 : 0;
            }
            if (SensorPort.this.mode == 128) {
                return (1023 - rawValue) * 100 / 1023;
            }
            return rawValue;
        }

        public final int readRawValue() {
            return SensorPort.readSensorValue(SensorPort.this.iPortId);
        }
    }

    protected class SensorReader {
        protected SensorReader() {
        }

        public void setType(int type) {
        }

        public void setMode(int mode) {
        }

        public int readValue() {
            return -1;
        }

        public int readRawValue() {
            return -1;
        }

        public int readValues(int[] values) {
            return -1;
        }

        public int readRawValues(int[] values) {
            return -1;
        }

        public void reset() {
        }
    }
}

