/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.Flash;

public class SystemSettings {
    private static final int SETTINGS_PAGE = 0;
    private static final int MAX_SETTING_SIZE = 16;
    private static byte[] buf = new byte[256];
    private static final String version = "NXJ Settings 1.0";
    private static final String versionName = "settings.version";
    private static final String[] names = new String[]{"settings.version", "lejos.volume", "lejos.default_program", "lejos.keyclick_volume", "lejos.default_autoRun", "lejos.sleep_time", "lejos.usb_serno", "lejos.usb_name", "lejos.bluetooth_pin"};

    static int getSlot(String key) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    static void setSlot(int slot, String value) {
        int i;
        for (i = 0; i < 16; ++i) {
            SystemSettings.buf[slot * 16 + i] = 0;
        }
        for (i = 0; i < value.length(); ++i) {
            SystemSettings.buf[slot * 16 + i] = (byte)value.charAt(i);
        }
    }

    static String getValue(int slot) {
        int l = 0;
        for (int i = 0; i < 16 && buf[slot * 16 + i] != 0; ++i) {
            ++l;
        }
        char[] chars = new char[l];
        for (int i = 0; i < l; ++i) {
            chars[i] = (char)buf[slot * 16 + i];
        }
        return new String(chars);
    }

    public static String getStringSetting(String key, String defaultValue) {
        int slot = SystemSettings.getSlot(key);
        if (slot < 0) {
            return defaultValue;
        }
        String s = SystemSettings.getValue(slot);
        if (s.length() == 0) {
            return defaultValue;
        }
        return s;
    }

    public static int getIntSetting(String key, int defaultValue) {
        String s = SystemSettings.getStringSetting(key, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static void setSetting(String key, String value) {
        int slot = SystemSettings.getSlot(key);
        if (slot >= 0) {
            SystemSettings.setSlot(slot, value);
            Flash.writePage(buf, 0);
        }
    }

    static String[] getSettingNames() {
        return names;
    }

    static {
        Flash.readPage(buf, 0);
        if (!SystemSettings.getValue(0).equals(version)) {
            for (int i = 0; i < Flash.BYTES_PER_PAGE; ++i) {
                SystemSettings.buf[i] = 0;
            }
            SystemSettings.setSetting(versionName, version);
        }
    }
}

