/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.rcxcomm;

import lejos.nxt.rcxcomm.PacketHandler;

public class LLCReliableHandler
extends PacketHandler {
    private byte[] inPacket = new byte[3];
    private byte[] outPacket = new byte[3];
    private byte[] inAck = new byte[2];
    private byte[] outAck = new byte[2];
    private int inPacketLength = 0;
    private boolean sequence = false;
    private boolean receiveSequence = false;

    public LLCReliableHandler(PacketHandler handler) {
        super(handler);
    }

    public void reset() {
        this.sequence = false;
        this.receiveSequence = false;
    }

    public boolean sendPacket(byte[] packet, int len) {
        int b = 240 + len;
        if (this.sequence) {
            b = (byte)(b | 8);
        }
        this.outPacket[0] = b;
        int sum = b;
        for (int i = 0; i < len; ++i) {
            sum += packet[i];
            this.outPacket[i + 1] = packet[i];
        }
        this.outPacket[len + 1] = (byte)sum;
        int j = 0;
        while (true) {
            int retLen;
            int sendTime = (int)System.currentTimeMillis();
            this.lowerHandler.sendPacket(this.outPacket, len + 2);
            do {
                Thread.yield();
            } while (!this.lowerHandler.isAckAvailable() && (int)System.currentTimeMillis() < sendTime + 500);
            if (this.lowerHandler.isAckAvailable() && (retLen = this.lowerHandler.receiveAck(this.inAck)) == 2 && this.inAck[0] == (byte)(b & 0xF8) && this.inAck[0] == this.inAck[1]) {
                this.sequence = !this.sequence;
                return true;
            }
            ++j;
        }
    }

    public int receivePacket(byte[] buffer) {
        int temp = this.inPacketLength - 2;
        for (int i = 0; i < temp; ++i) {
            buffer[i] = this.inPacket[i + 1];
        }
        this.inPacketLength = 0;
        return temp;
    }

    public boolean isPacketAvailable() {
        if (this.inPacketLength > 0) {
            return true;
        }
        while (this.lowerHandler.isPacketAvailable()) {
            int len = this.lowerHandler.receivePacket(this.inPacket);
            int sum = 0;
            for (int i = 0; i < len - 1; ++i) {
                sum += this.inPacket[i];
            }
            if ((byte)sum != this.inPacket[len - 1]) continue;
            this.outAck[0] = (byte)(this.inPacket[0] & 0xF8);
            this.outAck[1] = this.outAck[0];
            this.lowerHandler.sendPacket(this.outAck, 2);
            if ((this.inPacket[0] & 8) != (this.receiveSequence ? 8 : 0)) continue;
            this.inPacketLength = len;
            this.receiveSequence = !this.receiveSequence;
            return true;
        }
        return false;
    }
}

